<?php

/** Skin map */
add_filter( 'cloudfw_skin_map_object', 'cloudfw_menubar_skin_map' );
function cloudfw_menubar_skin_map( $map ){
    $map-> id      ( 'menubar_accent_gradient' )
        -> selector( '.menu-bar .ui--accent-gradient' )
        -> sync    ( 'color', 'accent', 'color', true )
        -> sync    ( 'text-shadow', 'accent', 'text-shadow', true )
        -> sync    ( 'gradient', 'accent', 'gradient', true );

    return $map;
}

if ( ! is_admin() && ! cloudfw_check_onoff( 'menubar', 'enable' ) ) {
	return;
}

class CloudFw_MenuBar_Widgets {
	public $widgets = array();
	public $basedir = '';

	/**
	 *	Construct Function
	 */
	function __construct(){
		/** Set the basedir */
		$this->basedir = dirname(__FILE__);

		/** Get widgets array */
		$this->widgets = cloudfw_walk_options( array(
			'widget'   => 'widget',
			'device'   => 'device',
		), cloudfw_get_option('menubar_widgets') );
	}

	/**
	 *	Widget List
	 */
	public function widget_list() {
		$widgets = array(
			'icon-box'      => esc_html__('Icon Box','envision'),
			'social-icons'  => esc_html__('Social Icons Widget','envision'),
			'custom-menu'   => esc_html__('Custom Menu Widget','envision'),
			'white-space-1' => esc_html__('White Space #1','envision'),
			'white-space-2' => esc_html__('White Space #2','envision'),
			'custom-html'   => esc_html__('Custom HTML or Shortcode','envision'),
		);

		//if ( cloudfw_woocommerce() ) {
			// $widgets['shop-cart'] = esc_html__('Shopping Cart Widget for WooCommerce','envision');
			$widgets['login'] = esc_html__('User Login Widget for WooCommerce','envision');
		//}

		return apply_filters( 'cloudfw_menubar_widgets', $widgets );
	}

	/**
	 *	Render Widgets
	 */
	static function render(){
		$class = new self();
		ob_start();	$class->get_widgets();
		$out = ob_get_contents(); ob_end_clean();

		echo cloudfw_escape($out);
	}

	/**
	 *	Get Widgets
	 */
	private function get_widgets() {
		$widget_list = $this->widget_list();
		foreach ((array)$this->widgets as $w) {
			$widget = isset( $w['widget'] ) ? $w['widget'] : null;
			if ( $widget && isset( $widget_list[ $widget ] ) ) {
				$this->call_widget( $widget, $w['device'] );
			}
		}
	}

	/**
	 *	Class Widget
	 */
	private function call_widget( $widget, $device ) {
		$path = trailingslashit($this->basedir) . 'menubar-widgets/' . $widget . '.php';

		if ( file_exists($path) ) {
			include($path);
		} else {
			do_action( "cloudfw_menubar_widget_{$widget}", compact( 'device' ) );
		}

	}

}
