<?php

if ( ! cloudfw_is_core_plugin_installed() ) {
    return;
}

$topbar_visibility = true;
$option_topbar_visibility = cloudfw_check_onoff( 'topbar', 'enable' );
$meta_topbar_visibility = cloudfw( 'get_meta', 'topbar_visibility' );

if ( ! $option_topbar_visibility ) {
    $topbar_visibility = false;
}

if ( 'off' == $meta_topbar_visibility ) {
    $topbar_visibility = false;
} elseif ( 'on' == $meta_topbar_visibility ) {
    $topbar_visibility = true;
}

if ( $topbar_visibility ) {

    $topbar_layout = cloudfw_get_option( 'topbar', 'layout' );
    $topbar_classes = array();

    if ( $topbar_layout == 'widgets-left' ) {
        $topbar_classes['widgets'] = 'left';
        $topbar_classes['text']    = 'right';
    } else {
        $topbar_classes['widgets'] = 'right';
        $topbar_classes['text']    = 'left';
    }
?>
            <div id="top-bar" class="clearfix">
                <div id="top-bar-background">
                    <div class="container relative">
                        <?php if ( class_exists('CloudFw_TopBar_Widgets') && $topbar_text = cloudfw_translate( 'text', 'topbar' ) ) { ?>
                        <div id="top-bar-text" class="top-bar-sides abs-<?php echo esc_attr($topbar_classes['text']); ?>">
                            <?php echo do_shortcode($topbar_text); ?>
                        </div>
                        <?php } ?>

                        <div id="top-bar-widgets" class="<?php echo esc_attr(cloudfw_visible('all')); ?>top-bar-sides abs-<?php echo esc_attr($topbar_classes['widgets']); ?>">
                            <?php CloudFw_TopBar_Widgets::render(); ?>
                        </div>
                    </div>
                </div>
            </div><!-- /#top-bar -->
<?php }
