<?php

add_action( 'tgmpa_register', 'cloudfw_register_required_plugins' );
function cloudfw_register_required_plugins() {

	$plugins = array(
		array(
			'name'    => 'Envision Core Plugin',
			'slug'    => 'envision-core',
			'source'  => TMP_INCLUDES . '/plugins/envision-core.zip',
			'version' => '1.0.7',
			'required' => true,
		),

		array(
			'name'    => 'Slider Revolution',
			'slug'    => 'revslider',
			'source'  => TMP_INCLUDES . '/plugins/revslider.zip',
			'version' => '6.5.6',
		),

		array(
			'name'    => 'Envision Custom Login Pages',
			'slug'    => 'wpt-login',
			'source'  => TMP_INCLUDES . '/plugins/wpt-login.zip',
			'version' => '1.2.4',
		),

		array(
			'name'   => 'Envato Market',
			'slug'   => 'envato-market',
			'source' => TMP_INCLUDES . '/plugins/envato-market.zip',
			'version' => '2.0.3',
		),

		array(
			'name' => 'Contact Form 7',
			'slug' => 'contact-form-7',
		),

		array(
			'name' => 'WooCommerce',
			'slug' => 'woocommerce',
		),
	);

	$config = array(
		'id'           => 'tgmpa',                 // Unique ID for hashing notices for multiple instances of TGMPA.
		'default_path' => '',                      // Default absolute path to bundled plugins.
		'menu'         => 'tgmpa-install-plugins', // Menu slug.
		'parent_slug'  => 'themes.php',            // Parent menu slug.
		'capability'   => 'edit_theme_options',    // Capability needed to view plugin install page, should be a capability associated with the parent menu used.
		'has_notices'  => true,                    // Show admin notices or not.
		'dismissable'  => true,                    // If false, a user cannot dismiss the nag message.
		'dismiss_msg'  => '',                      // If 'dismissable' is false, this message will be output at top of nag.
		'is_automatic' => false,                   // Automatically activate plugins after installation or not.
		'message'      => '',
		'strings'      => array(
			'page_title'                      => esc_html__( 'Install Required Plugins', 'envision' ),
			'menu_title'                      => esc_html__( 'Install Plugins', 'envision' ),
			/* translators: %s: plugin name. */
			'installing'                      => esc_html__( 'Installing Plugin: %s', 'envision' ),
			/* translators: %s: plugin name. */
			'updating'                        => esc_html__( 'Updating Plugin: %s', 'envision' ),
			'oops'                            => esc_html__( 'Something went wrong with the plugin API.', 'envision' ),
			'notice_can_install_required'     => _n_noop(
				/* translators: 1: plugin name(s). */
				'This theme requires the following plugin: %1$s.',
				'This theme requires the following plugins: %1$s.',
				'envision'
			),
			'notice_can_install_recommended'  => _n_noop(
				/* translators: 1: plugin name(s). */
				'This theme recommends the following plugin: %1$s.',
				'This theme recommends the following plugins: %1$s.',
				'envision'
			),
			'notice_ask_to_update'            => _n_noop(
				/* translators: 1: plugin name(s). */
				'The following plugin needs to be updated to its latest version to ensure maximum compatibility with this theme: %1$s.',
				'The following plugins need to be updated to their latest version to ensure maximum compatibility with this theme: %1$s.',
				'envision'
			),
			'notice_ask_to_update_maybe'      => _n_noop(
				/* translators: 1: plugin name(s). */
				'There is an update available for: %1$s.',
				'There are updates available for the following plugins: %1$s.',
				'envision'
			),
			'notice_can_activate_required'    => _n_noop(
				/* translators: 1: plugin name(s). */
				'The following required plugin is currently inactive: %1$s.',
				'The following required plugins are currently inactive: %1$s.',
				'envision'
			),
			'notice_can_activate_recommended' => _n_noop(
				/* translators: 1: plugin name(s). */
				'The following recommended plugin is currently inactive: %1$s.',
				'The following recommended plugins are currently inactive: %1$s.',
				'envision'
			),
			'install_link'                    => _n_noop(
				'Begin installing plugin',
				'Begin installing plugins',
				'envision'
			),
			'update_link' 					  => _n_noop(
				'Begin updating plugin',
				'Begin updating plugins',
				'envision'
			),
			'activate_link'                   => _n_noop(
				'Begin activating plugin',
				'Begin activating plugins',
				'envision'
			),
			'return'                          => esc_html__( 'Return to Required Plugins Installer', 'envision' ),
			'plugin_activated'                => esc_html__( 'Plugin activated successfully.', 'envision' ),
			'activated_successfully'          => esc_html__( 'The following plugin was activated successfully:', 'envision' ),
			/* translators: 1: plugin name. */
			'plugin_already_active'           => esc_html__( 'No action taken. Plugin %1$s was already active.', 'envision' ),
			/* translators: 1: plugin name. */
			'plugin_needs_higher_version'     => esc_html__( 'Plugin not activated. A higher version of %s is needed for this theme. Please update the plugin.', 'envision' ),
			/* translators: 1: dashboard link. */
			'complete'                        => esc_html__( 'All plugins installed and activated successfully. %1$s', 'envision' ),
			'dismiss'                         => esc_html__( 'Dismiss this notice', 'envision' ),
			'notice_cannot_install_activate'  => esc_html__( 'There are one or more required or recommended plugins to install, update or activate.', 'envision' ),
			'contact_admin'                   => esc_html__( 'Please contact the administrator of this site for help.', 'envision' ),
			'nag_type'                        => '', // Determines admin notice type - can only be one of the typical WP notice classes, such as 'updated', 'update-nag', 'notice-warning', 'notice-info' or 'error'. Some of which may not work as expected in older WP versions.
		),
	);

	tgmpa( $plugins, $config );

}
