<?php
/**
 *	Configuration Wizard
 *
 *	@since 1.0
 */

$g_page = 'admin.php?page='.$cloudfw_setting_slug.'&q=1&';

/*-----------------------------------------------------------------------------------*/
/*	Activate - Document
/*-----------------------------------------------------------------------------------*/

$guide["installing"] = array(
	'msg' => sprintf(__('Activate %s','envision'), CLOUDFW_THEMENAME ), 
	'score' => 3,
	'done'	=> TRUE
);

$guide["doc"] = array(
	'msg' => __('Read the theme documentation','envision'), 
	'score' => 1,
	'url'	=> CLOUDFW_ITEMDOC,
	'custom_text'	=> array(__('mark as read','envision'),__('mark as unread','envision'))
);

/*-----------------------------------------------------------------------------------*/
/*	General
/*-----------------------------------------------------------------------------------*/

$guide[] = array(
	'group'	=> __('General Settings','envision')
);

$guide["logo"] = array(
	'msg'	=> __('Upload a logo image','envision'), 
	'score'	=> 4,
	'url'	=> cloudfw_admin_url('global') . '#logo_favicon',
	'done'	=> (!empty($_opt[PFIX."_logo"]["image"]) && $_opt[PFIX."_logo"]["image"] !== TMP_URL.'/lib/images/logo.png') ? TRUE: FALSE,
);

$guide["custom_sidebars"] = array(
	'msg'	=> __('Create custom sidebars','envision') . ' <em>' . __('(optional)','envision') . ' </em>', 
	'score'	=> 0,
	'url'	=> cloudfw_admin_url('global', '4'),
);

$guide["widgets"] = array(
	'msg'	=> __('Manage sidebars and widgets','envision'), 
	'score'	=> 4,
	'url'	=> admin_url('widgets.php'),
);


/*-----------------------------------------------------------------------------------*/
/*	Visual Settings
/*-----------------------------------------------------------------------------------*/

$guide[] = array(
	'group'	=> __('Visual Settings','envision')
	);

$guide["visual_set"] = array(
	'msg' 	=> __('Edit the default visual set or create new one','envision'), 
	'score' => 5,
	'url'	=> cloudfw_admin_url('visual', '0'),
	'done'	=> ($skin["mode"] !== 'defined' && $skin["id"] !== PFIX.'_skin_default_data' ) ? TRUE: FALSE
	);


/*-----------------------------------------------------------------------------------*/
/*	Sliders
/*-----------------------------------------------------------------------------------*/

$guide[] = array(
	'group'	=> __('Slider','envision')
);

$guide["revslider"] = array(
	'msg'	=> __('Install Revolution slider plugin','envision'), 
	'score'	=> 3,
	'done'	=> (class_exists('RevSlider')) ? TRUE: FALSE,
	'unlink'=> false
);

/*-----------------------------------------------------------------------------------*/
/*	Homepage
/*-----------------------------------------------------------------------------------*/

$guide[] = array(
	'group'	=> __('Homepage','envision')
	);

$guide["homepage"] = array(
	'msg'	=> __('Create a page for your front page','envision'), 
	'score'	=> 3,
	'url'	=> admin_url('post-new.php?post_type=page'),
	'done'	=> (get_option('page_on_front'))? TRUE: FALSE,
	'help'	=> (get_option('page_on_front'))? '<a class="inlink" href="post.php?action=edit&post='.get_option('page_on_front').'">'.__('edit','envision').'</a>': '',
	'unlink'=> false,
);

$guide["homepage_define"] = array(
	'msg'	=> __('Define the page as the front page','envision'), 
	'score'	=> 3,
	'url'	=> admin_url('options-reading.php'),
	'done'	=> (get_option('page_on_front'))? TRUE: FALSE,
	'unlink'=> false,
);

/*-----------------------------------------------------------------------------------*/
/*	Blog
/*-----------------------------------------------------------------------------------*/

$guide[] = array(
	'group'	=> __('Blog','envision')
);

$guide["blog"] = array(
	'msg'	=> __('Create a page for blog','envision'), 
	'score'	=> 5,
	'url'	=> admin_url('post-new.php?post_type=page'),
	'done'	=> (get_option('page_for_posts'))? TRUE: FALSE,
	'help'	=> (get_option('page_for_posts'))? '<a class="inlink" href="post.php?action=edit&post='.get_option('page_for_posts').'">'.__('edit','envision').'</a>': '',
	'unlink'=> false
);

$guide["homepage_define"] = array(
	'msg'	=> __('Define the page as the blog page','envision'), 
	'score'	=> 3,
	'url'	=> admin_url('options-reading.php'),
	'done'	=> (get_option('page_for_posts'))? TRUE: FALSE,
	'unlink'=> false,
);

$guide["blog_posts"] = array(
	'msg'	=> __('Create some posts for your blog','envision'), 
	'score'	=> 1,
	'url'	=> admin_url('post-new.php?post_type=post'),
	'unlink'=> false
);

/*-----------------------------------------------------------------------------------*/
/*	Portfolio
/*-----------------------------------------------------------------------------------*/

$guide[] = array(
	'group'	=> __('Portfolio','envision')
);


$guide["portcatcreate"] = array(
	'msg'	=> __('Create some portfolio categories','envision'), 
	'score'	=> 2,
	'url'	=> admin_url('edit-tags.php?taxonomy=portfolio-category&post_type=' . cloudfw_get_option( 'portfolio', 'slug' )),
	'done'	=> (count((array) get_terms('portfolio-category', 'hide_empty=0'))>0)? TRUE: FALSE,
);

$guide["portpost_create"] = array(
	'msg'	=> __('Create some portfolio posts','envision'), 
	'score'	=> 4,
	'url'	=> admin_url('post-new.php?post_type=' . cloudfw_get_option( 'portfolio', 'slug' )),
	//'done'	=> (count((array) get_terms('portfolio-category', 'hide_empty=0'))>0)? TRUE: FALSE,
);

$guide["portpage_create"] = array(
	'msg'	=> __('Create a page for your portfolio','envision'), 
	'score'	=> 3,
	'url'	=> admin_url('post-new.php?post_type=page'),
	'done'	=> _if(!empty($_opt[PFIX."_portfolio"]["page"]), TRUE, FALSE),
);

$guide["portpage_define"] = array(
	'msg'	=> __('Define the page as main portfolio page','envision'), 
	'score'	=> 2,
	'url'	=> cloudfw_admin_url('portfolio', '0'),
	'done'	=> _if(!empty($_opt[PFIX."_portfolio"]["page"]), TRUE, FALSE),
);


/*-----------------------------------------------------------------------------------*/
/*	Navigation Menu
/*-----------------------------------------------------------------------------------*/

$guide[] = array(
	'group'	=> __('Navigation Menu','envision')
	);


$guide["navmenu"] = array(
	'msg'	=> __('Manage the navigation menu','envision'), 
	'score'	=> 3,
	'url'	=> 'nav-menus.php',
	'done'	=> ( has_nav_menu( 'primary' ) )? TRUE: FALSE
	);

/*-----------------------------------------------------------------------------------*/
/*	Optional
/*-----------------------------------------------------------------------------------*/

$guide[] = array(
	'group'	=> __('Optional','envision')
	);

$guide["backup"] = array(
	'msg'	=> __('Backup all options','envision'), 
	'score'	=> 0,
	'url'	=> $g_page.'tab=system#import_export'
	);

$guide["vote"] = array(
	'msg'	=> sprintf( __('Please vote %s on ThemeForest','envision'), CLOUDFW_THEMENAME ), 
	'score'	=> 0,
	'url'	=> CLOUDFW_ITEMPAGE
	);