<?php

$scheme[ cloudfw_id_for_sequence( $scheme, $number ) ] = array(
	'type'			=>	'section',
	'title'			=>	esc_html__('Navigation','envision'),
	'data'			=>	array(


		array(
			'type'		=>	'module-set',
			'title'		=>	esc_html__('Layout','envision'),
			'closable'	=>	true,
			'state'		=>	'opened',
			'data'		=>	array(

				## Module Item
				array(
					'type'		=>	'module',
					'ucode'		=>	'NAVIGATION GAP',
					'title'		=>	esc_html__('Horizontal Gap for the Top Level Navigation Items','envision'),
					'data'		=>	array(

						array(
							'type'		=>	'text',
							'title'		=>	esc_html__('Large devices (desktops)','envision'),
							'id'		=>	cloudfw_sanitize('navigation_level_0_paddings_wide','padding-horizontal'),
							'value'		=>	$data['navigation_level_0_paddings_wide']['padding-horizontal'],
							'width'		=>	50,
							'holder'	=>	20,
							'unit'		=>	'px',
						),

						array(
							'type'		=>	'text',
							'title'		=>	esc_html__('Medium devices (desktops)','envision'),
							'id'		=>	cloudfw_sanitize('navigation_level_0_paddings_standard','padding-horizontal'),
							'value'		=>	$data['navigation_level_0_paddings_standard']['padding-horizontal'],
							'width'		=>	50,
							'holder'	=>	20,
							'unit'		=>	'px',
						),

						array(
							'type'		=>	'text',
							'title'		=>	esc_html__('Small devices (tablets)','envision'),
							'id'		=>	cloudfw_sanitize('navigation_level_0_paddings_tablet','padding-horizontal'),
							'value'		=>	$data['navigation_level_0_paddings_tablet']['padding-horizontal'],
							'width'		=>	50,
							'holder'	=>	20,
							'unit'		=>	'px',
						),

					)

				),


			)

		),


		array(
			'type'		=>	'module-set',
			'title'		=>	esc_html__('First Level','envision'),
			'closable'	=>	true,
			'state'		=>	'opened',
			'data'		=>	array(

				## Module Item
				array(
					'type'		=>	'module',
					'ucode'		=>	'NAVIGATION LINK',
					'title'		=>	esc_html__('Menu Item Background (Normal)','envision'),
					'data'		=>	array(
						## Element
						array(
							'type'		=>	'gradient',
							'title'		=>	esc_html__('Background Gradient','envision'),
							'id'		=>	cloudfw_sanitize('navigation_level_0','gradient'),
							'value'		=>	$data['navigation_level_0']['gradient'],
						),

					)

				),

				## Module Item
				array(
					'type'		=>	'text-shadow-kit',
					'merge'		=>	'module',
					'title'		=>	esc_html__('Menu Item Texts (Normal)','envision'),
					'id'		=>	cloudfw_sanitize('navigation_level_0'),
					'value'		=>	$data['navigation_level_0'],
					'ucode'		=>	'NAVIGATION LINK',
				),

				## Module Item
				array(
					'type'		=>	'border-radius-kit',
					'merge'		=>	'module',
					'title'		=>	esc_html__('Menu Item Border Radius (Normal)','envision'),
					'id'		=>	cloudfw_sanitize('navigation_level_0_border_radius'),
					'value'		=>	$data['navigation_level_0_border_radius'],
					'ucode'		=>	'NAVIGATION BORDER RADIUS',
				),

				## Module Item
				array(
					'type'		=>	'module',
					'ucode'		=>	'NAVIGATION LINK',
					'title'		=>	esc_html__('Menu Item Background (Hover)','envision'),
					'data'		=>	array(
						## Element
						array(
							'type'		=>	'gradient',
							'title'		=>	esc_html__('Background Gradient','envision'),
							'id'		=>	cloudfw_sanitize('navigation_level_0_hover2','gradient'),
							'value'		=>	$data['navigation_level_0_hover2']['gradient'],
						),

					)

				),

				## Module Item
				array(
					'type'		=>	'text-shadow-kit',
					'merge'		=>	'module',
					'title'		=>	esc_html__('Menu Item Texts (Hover)','envision'),
					'id'		=>	cloudfw_sanitize('navigation_level_0_hover2'),
					'value'		=>	$data['navigation_level_0_hover2'],
					'ucode'		=>	'NAVIGATION LINK',
				),


				## Module Item
				array(
					'type'		=>	'module',
					'ucode'		=>	'NAVIGATION LINK LINE',
					'title'		=>	esc_html__('Menu Item Bottom Border','envision'),
					'layout'	=>	'float',
					'data'		=>	array(

						array(
							'type'		=>	'color',
							'style'		=>	'horizontal',
							'id'		=>	cloudfw_sanitize('navigation_level_0_active_border','border-color'),
							'value'		=>	$data['navigation_level_0_active_border']['border-color'],
						),


					)

				),

				## Module Item
				/*array(
					'type'		=>	'module',
					'ucode'		=>	'NAVIGATION LINK',
					'title'		=>	esc_html__('Current Menu Item','cloudfw'),
					'layout'	=>	'float',
					'data'		=>	array(

						array(
							'type'		=>	'color',
							'style'		=>	'horizontal',
							'title'		=>	esc_html__('Normal','cloudfw'),
							'id'		=>	cloudfw_sanitize('navigation_level_0_current_item','color'),
							'value'		=>	$data['navigation_level_0_current_item']['color'],
						),
						array(
							'type'		=>	'color',
							'style'		=>	'horizontal',
							'title'		=>	esc_html__('Hover Color','cloudfw'),
							'id'		=>	cloudfw_sanitize('navigation_level_0_current_item_hover','color'),
							'value'		=>	$data['navigation_level_0_current_item_hover']['color'],
						),

					)

				),*/

				## Module Item
				array(
					'type'		=>	'module',
					'ucode'		=>	'NAVIGATION LINK',
					'title'		=>	esc_html__('Menu Item Background (Active Item)','envision'),
					'data'		=>	array(
						## Element
						array(
							'type'		=>	'gradient',
							'title'		=>	esc_html__('Background Gradient','envision'),
							'id'		=>	cloudfw_sanitize('navigation_level_0_current_item','gradient'),
							'value'		=>	$data['navigation_level_0_current_item']['gradient'],
						),

					)

				),

				## Module Item
				array(
					'type'		=>	'text-shadow-kit',
					'merge'		=>	'module',
					'title'		=>	esc_html__('Menu Item Texts (Active Item)','envision'),
					'id'		=>	cloudfw_sanitize('navigation_level_0_current_item'),
					'value'		=>	$data['navigation_level_0_current_item'],
					'ucode'		=>	'NAVIGATION LINK',
				),

				## Module Item
				/*array(
					'type'		=>	'module',
					'ucode'		=>	'NAVIGATION LINK ACTIVE',
					'title'		=>	esc_html__('Active Menu Item (Sub Menu Opened State)','cloudfw'),
					'layout'	=>	'float',
					'data'		=>	array(
						## Element
						array(
							'type'		=>	'gradient',
							'title'		=>	esc_html__('Background Gradient','cloudfw'),
							'id'		=>	cloudfw_sanitize('navigation_level_0_opened','gradient'),
							'value'		=>	$data['navigation_level_0_opened']['gradient'],
						),

						## Element
						array(
							'type'		=>	'color',
							'style'		=>	'horizontal',
							'title'		=>	esc_html__('Text Color','cloudfw'),
							'id'		=>	cloudfw_sanitize('navigation_level_0_opened','color'),
							'value'		=>	$data['navigation_level_0_opened']['color'],

						),

						## Element
						array(
							'type'		=>	'color',
							'style'		=>	'horizontal',
							'title'		=>	esc_html__('Text Shadow','cloudfw'),
							'id'		=>	cloudfw_sanitize('navigation_level_0_opened','text-shadow color'),
							'value'		=>	$data['navigation_level_0_opened']['text-shadow']['color'],

						),

						## Element
						array(
							'type'		=>	'select',
							'style'		=>	'horizontal',
							'title'		=>	esc_html__('Shadow Direction','cloudfw'),
							'id'		=>	cloudfw_sanitize('navigation_level_0_opened','text-shadow direction'),
							'value'		=>	$data['navigation_level_0_opened']['text-shadow']['direction'],
							'source'	=>	array(
								'-1'		=>	esc_html__('Top','cloudfw'),
								'1'			=>	esc_html__('Bottom','cloudfw'),
							),
							'width'		=>	120

						),

					)

				),*/

			)

		),


		array(
			'type'		=>	'module-set',
			'title'		=>	esc_html__('First Level in Sticky Mode','envision'),
			'closable'	=>	true,
			'state'		=>	'opened',
			'data'		=>	array(

				## Module Item
				array(
					'type'		=>	'module',
					'ucode'		=>	'NAVIGATION LINK',
					'title'		=>	esc_html__('Header Background in Sticky Mode','envision'),
					'data'		=>	array(

						array(
							'type'		=>	'grid',
							'data'		=>	array(

								array(
									'type'		=>	'gradient',
									'title'		=>	esc_html__('Background-Color','envision'),
									'id'		=>	cloudfw_sanitize('navigation_sticky','gradient'),
									'value'		=>	$data['navigation_sticky']['gradient'],
								),
								array(
									'type'		=>	'bg-set',
									'id'		=>	'navigation_sticky',
									'id:pattern'=>	'navigation_sticky',
									'value'		=>	$data,
									'attachment'=>	false
								)

							)

						),

					)

				),

				## Module Item
				array(
					'type'		=>	'module',
					'ucode'		=>	'NAVIGATION LINK',
					'title'		=>	esc_html__('Menu Item Background (Normal) in Sticky Mode','envision'),
					'data'		=>	array(
						## Element
						array(
							'type'		=>	'gradient',
							'title'		=>	esc_html__('Background Gradient','envision'),
							'id'		=>	cloudfw_sanitize('navigation_level_0_sticky','gradient'),
							'value'		=>	$data['navigation_level_0_sticky']['gradient'],
						),

					)

				),

				## Module Item
				array(
					'type'		=>	'text-shadow-kit',
					'merge'		=>	'module',
					'title'		=>	esc_html__('Menu Item Texts (Normal) in Sticky Mode','envision'),
					'id'		=>	cloudfw_sanitize('navigation_level_0_sticky'),
					'value'		=>	$data['navigation_level_0_sticky'],
					'ucode'		=>	'NAVIGATION LINK',
				),

				## Module Item
				array(
					'type'		=>	'module',
					'ucode'		=>	'NAVIGATION LINK',
					'title'		=>	esc_html__('Menu Item Background (Hover) in Sticky Mode','envision'),
					'data'		=>	array(
						## Element
						array(
							'type'		=>	'gradient',
							'title'		=>	esc_html__('Background Gradient','envision'),
							'id'		=>	cloudfw_sanitize('navigation_level_0_sticky_hover','gradient'),
							'value'		=>	$data['navigation_level_0_sticky_hover']['gradient'],
						),

					)

				),

				## Module Item
				array(
					'type'		=>	'text-shadow-kit',
					'merge'		=>	'module',
					'title'		=>	esc_html__('Menu Item Texts (Hover) in Sticky Mode','envision'),
					'id'		=>	cloudfw_sanitize('navigation_level_0_sticky_hover'),
					'value'		=>	$data['navigation_level_0_sticky_hover'],
					'ucode'		=>	'NAVIGATION LINK',
				),

			)

		),


		array(
			'type'		=>	'module-set',
			'title'		=>	esc_html__('First Level in Overlap Mode','envision'),
			'closable'	=>	true,
			'state'		=>	'opened',
			'data'		=>	array(

				## Module Item
				array(
					'type'		=>	'module',
					'ucode'		=>	'NAVIGATION',
					'title'		=>	esc_html__('Header Background in Overlap Mode','envision'),
					'data'		=>	array(

						array(
							'type'		=>	'grid',
							'data'		=>	array(

								array(
									'type'		=>	'gradient',
									'title'		=>	esc_html__('Background-Color','envision'),
									'id'		=>	cloudfw_sanitize('navigation_overlapping_background','gradient'),
									'value'		=>	$data['navigation_overlapping_background']['gradient'],
								),
								array(
									'type'		=>	'bg-set',
									'id'		=>	'navigation_overlapping_background',
									'id:pattern'=>	'navigation_overlapping_background',
									'value'		=>	$data,
									'attachment'=>	false
								)

							)

						),

					)

				),

				array(
					'type'      =>  'module',
					'ucode'     =>  'NAVIGATION',
					'title'     =>  esc_html__('Header Background Opacity in Overlap Mode','envision'),
					'data'      =>  array(

						array(
							'type'      =>  'slider',
							'id'		=>	cloudfw_sanitize('navigation_overlapping','opacity'),
							'value'		=>	$data['navigation_overlapping']['opacity'],
							'min'       =>  0,
							'max'       =>  100,
							'step'      =>  5,
							'width'     =>  250,
							'unit'		=>	'%',
						),

					)

				),

				## Module Item
				array(
					'type'		=>	'module',
					'ucode'		=>	'NAVIGATION LINK',
					'title'		=>	esc_html__('Menu Item Background (Normal) in Overlap Mode','envision'),
					'data'		=>	array(
						## Element
						array(
							'type'		=>	'gradient',
							'title'		=>	esc_html__('Background Gradient','envision'),
							'id'		=>	cloudfw_sanitize('navigation_level_0_overlapping','gradient'),
							'value'		=>	$data['navigation_level_0_overlapping']['gradient'],
						),

					)

				),

				## Module Item
				array(
					'type'		=>	'text-shadow-kit',
					'merge'		=>	'module',
					'title'		=>	esc_html__('Menu Item Texts (Normal) in Overlap Mode','envision'),
					'id'		=>	cloudfw_sanitize('navigation_level_0_overlapping'),
					'value'		=>	$data['navigation_level_0_overlapping'],
					'ucode'		=>	'NAVIGATION LINK',
				),

				## Module Item
				array(
					'type'		=>	'module',
					'ucode'		=>	'NAVIGATION LINK',
					'title'		=>	esc_html__('Menu Item Background (Hover) in Overlap Mode','envision'),
					'data'		=>	array(
						## Element
						array(
							'type'		=>	'gradient',
							'title'		=>	esc_html__('Background Gradient','envision'),
							'id'		=>	cloudfw_sanitize('navigation_level_0_overlapping_hover','gradient'),
							'value'		=>	$data['navigation_level_0_overlapping_hover']['gradient'],
						),

					)

				),

				## Module Item
				array(
					'type'		=>	'text-shadow-kit',
					'merge'		=>	'module',
					'title'		=>	esc_html__('Menu Item Texts (Hover) in Overlap Mode','envision'),
					'id'		=>	cloudfw_sanitize('navigation_level_0_overlapping_hover'),
					'value'		=>	$data['navigation_level_0_overlapping_hover'],
					'ucode'		=>	'NAVIGATION LINK',
				),

			)

		),

		array(
			'type'		=>	'module-set',
			'title'		=>	esc_html__('Header Style #2 Options','envision'),
			'closable'	=>	true,
			'state'		=>	'opened',
			'data'		=>	array(


				## Module Item
				array(
					'type'		=>	'module',
					'ucode'		=>	'HEADER STYLE 2',
					'title'		=>	esc_html__('Menu Container Background','envision'),
					'data'		=>	array(
						## Element
						array(
							'type'		=>	'gradient',
							'id'		=>	cloudfw_sanitize('header_style_2_background','gradient'),
							'value'		=>	$data['header_style_2_background']['gradient'],
						),

					)

				),

				## Module Item
				array(
					'type'		=>	'module',
					'ucode'		=>	'HEADER STYLE 2',
					'title'		=>	esc_html__('Border Color','envision'),
					'layout'	=>	'float',
					'data'		=>	array(

						array(
							'type'		=>	'color',
							'style'		=>	'horizontal',
							'id'		=>	cloudfw_sanitize('header_style_2_border','border-color'),
							'value'		=>	$data['header_style_2_border']['border-color'],
						),
					)

				),


			)
		),

		array(
			'type'		=>	'module-set',
			'title'		=>	esc_html__('Header Style #3 Options','envision'),
			'closable'	=>	true,
			'state'		=>	'opened',
			'data'		=>	array(


				## Module Item
				array(
					'type'		=>	'module',
					'ucode'		=>	'HEADER STYLE 3',
					'title'		=>	esc_html__('Menu Container Background','envision'),
					'data'		=>	array(
						## Element
						array(
							'type'		=>	'gradient',
							'id'		=>	cloudfw_sanitize('header_style_3_background','gradient'),
							'value'		=>	$data['header_style_3_background']['gradient'],
						),

					)
				),

				array(
					'type'      =>  'module',
					'ucode'		=>	'HEADER STYLE 3',
					'title'		=>	esc_html__('Menu Container Background Opacity','envision'),
					'data'      =>  array(

						array(
							'type'      =>  'slider',
							'id'		=>	cloudfw_sanitize('header_style_3_background_opacity','opacity'),
							'value'		=>	$data['header_style_3_background_opacity']['opacity'],
							'min'       =>  0,
							'max'       =>  100,
							'step'      =>  5,
							'width'     =>  250,
							'unit'		=>	'%',
						),

					)
				),

				## Module Item
				array(
					'type'		=>	'border-radius-kit',
					'merge'		=>	'module',
					'title'		=>	esc_html__('Menu Container Border Radius','envision'),
					'id'		=>	cloudfw_sanitize('header_style_3_background'),
					'value'		=>	$data['header_style_3_background'],
					'ucode'		=>	'NAVIGATION BORDER RADIUS',
				),
			)
		),

		array(
			'type'		=>	'module-set',
			'title'		=>	esc_html__('Sub Levels','envision'),
			'closable'	=>	true,
			'state'		=>	'opened',
			'data'		=>	array(

				## Module Item
				array(
					'type'		=>	'module',
					'ucode'		=>	'NAVIGATION SUB BORDER',
					'title'		=>	esc_html__('Sub Level Menu Border','envision'),
					'layout'	=>	'float',
					'data'		=>	array(

						array(
							'type'		=>	'color',
							'style'		=>	'horizontal',
							'id'		=>	cloudfw_sanitize('navigation_fallout_border','border-color'),
							'value'		=>	$data['navigation_fallout_border']['border-color'],
						),

					)

				),

				## Module Item
				array(
					'type'		=>	'module',
					'ucode'		=>	'NAVIGATION SUB LINK',
					'title'		=>	esc_html__('Link Colors','envision'),
					'layout'	=>	'float',
					'data'		=>	array(

						array(
							'type'		=>	'gradient',
							'title'		=>	esc_html__('Background Gradient','envision'),
							'id'		=>	cloudfw_sanitize('navigation_fallout_link','gradient'),
							'value'		=>	$data['navigation_fallout_link']['gradient'],
						),

						array(
							'type'		=>	'color',
							'style'		=>	'horizontal',
							'title'		=>	esc_html__('Text Color','envision'),
							'id'		=>	cloudfw_sanitize('navigation_fallout_link','color'),
							'value'		=>	$data['navigation_fallout_link']['color'],
						),

						## Element
						array(
							'type'		=>	'color',
							'style'		=>	'horizontal',
							'title'		=>	esc_html__('Text Shadow','envision'),
							'id'		=>	cloudfw_sanitize('navigation_fallout_link','text-shadow color'),
							'value'		=>	$data['navigation_fallout_link']['text-shadow']['color'],

						),

						## Element
						array(
							'type'		=>	'select',
							'style'		=>	'horizontal',
							'title'		=>	esc_html__('Shadow Direction','envision'),
							'id'		=>	cloudfw_sanitize('navigation_fallout_link','text-shadow direction'),
							'value'		=>	$data['navigation_fallout_link']['text-shadow']['direction'],
							'source'	=>	array(
								'-1'		=>	esc_html__('Top','envision'),
								'1'			=>	esc_html__('Bottom','envision'),
							),
							'width'		=>	120

						),


					)

				),

				## Module Item
				array(
					'type'		=>	'module',
					'ucode'		=>	'NAVIGATION SUB LINK',
					'title'		=>	esc_html__('Link Colors Hover','envision'),
					'layout'	=>	'float',
					'data'		=>	array(

						array(
							'type'		=>	'gradient',
							'title'		=>	esc_html__('Background Gradient','envision'),
							'id'		=>	cloudfw_sanitize('navigation_fallout_link_hover','gradient'),
							'value'		=>	$data['navigation_fallout_link_hover']['gradient'],
						),

						array(
							'type'		=>	'color',
							'style'		=>	'horizontal',
							'title'		=>	esc_html__('Text Color','envision'),
							'id'		=>	cloudfw_sanitize('navigation_fallout_link_hover','color'),
							'value'		=>	$data['navigation_fallout_link_hover']['color'],
						),

						## Element
						array(
							'type'		=>	'color',
							'style'		=>	'horizontal',
							'title'		=>	esc_html__('Text Shadow','envision'),
							'id'		=>	cloudfw_sanitize('navigation_fallout_link_hover','text-shadow color'),
							'value'		=>	$data['navigation_fallout_link_hover']['text-shadow']['color'],

						),

						## Element
						array(
							'type'		=>	'select',
							'style'		=>	'horizontal',
							'title'		=>	esc_html__('Shadow Direction','envision'),
							'id'		=>	cloudfw_sanitize('navigation_fallout_link_hover','text-shadow direction'),
							'value'		=>	$data['navigation_fallout_link_hover']['text-shadow']['direction'],
							'source'	=>	array(
								'-1'		=>	esc_html__('Top','envision'),
								'1'			=>	esc_html__('Bottom','envision'),
							),
							'width'		=>	120

						),


					)

				),

				## Module Item
				array(
					'type'		=>	'module',
					'ucode'		=>	'NAVIGATION SUB LINK',
					'title'		=>	esc_html__('Separator Color','envision'),
					'layout'	=>	'float',
					'data'		=>	array(

						array(
							'type'		=>	'color',
							'style'		=>	'horizontal',
							'id'		=>	cloudfw_sanitize('navigation_fallout_link','border-color'),
							'value'		=>	$data['navigation_fallout_link']['border-color'],
						),

					)

				),

				## Module Item
				array(
					'type'		=>	'module',
					'ucode'		=>	'NAVIGATION CURRENT SUB LINK',
					'title'		=>	esc_html__('Current Sub Item Color','envision'),
					'layout'	=>	'float',
					'data'		=>	array(

						array(
							'type'		=>	'gradient',
							'title'		=>	esc_html__('Background Gradient','envision'),
							'id'		=>	cloudfw_sanitize('navigation_fallout_current_sub','gradient'),
							'value'		=>	$data['navigation_fallout_current_sub']['gradient'],
						),

						array(
							'type'		=>	'color',
							'style'		=>	'horizontal',
							'title'		=>	esc_html__('Text Color','envision'),
							'id'		=>	cloudfw_sanitize('navigation_fallout_current_sub','color'),
							'value'		=>	$data['navigation_fallout_current_sub']['color'],
						),

						## Element
						array(
							'type'		=>	'color',
							'style'		=>	'horizontal',
							'title'		=>	esc_html__('Text Shadow','envision'),
							'id'		=>	cloudfw_sanitize('navigation_fallout_current_sub','text-shadow color'),
							'value'		=>	$data['navigation_fallout_current_sub']['text-shadow']['color'],

						),

						## Element
						array(
							'type'		=>	'select',
							'style'		=>	'horizontal',
							'title'		=>	esc_html__('Shadow Direction','envision'),
							'id'		=>	cloudfw_sanitize('navigation_fallout_current_sub','text-shadow direction'),
							'value'		=>	$data['navigation_fallout_current_sub']['text-shadow']['direction'],
							'source'	=>	array(
								'-1'		=>	esc_html__('Top','envision'),
								'1'			=>	esc_html__('Bottom','envision'),
							),
							'width'		=>	120

						),


					)

				),

				## Module Item
				array(
					'type'		=>	'module',
					'ucode'		=>	'NAVIGATION CURRENT SUB LINK',
					'title'		=>	esc_html__('Current Sub Item Hover Color','envision'),
					'layout'	=>	'float',
					'data'		=>	array(

						array(
							'type'		=>	'gradient',
							'title'		=>	esc_html__('Background Gradient','envision'),
							'id'		=>	cloudfw_sanitize('navigation_fallout_current_sub_hover','gradient'),
							'value'		=>	$data['navigation_fallout_current_sub_hover']['gradient'],
						),

						array(
							'type'		=>	'color',
							'style'		=>	'horizontal',
							'title'		=>	esc_html__('Text Color','envision'),
							'id'		=>	cloudfw_sanitize('navigation_fallout_current_sub_hover','color'),
							'value'		=>	$data['navigation_fallout_current_sub_hover']['color'],
						),

						## Element
						array(
							'type'		=>	'color',
							'style'		=>	'horizontal',
							'title'		=>	esc_html__('Text Shadow','envision'),
							'id'		=>	cloudfw_sanitize('navigation_fallout_current_sub_hover','text-shadow color'),
							'value'		=>	$data['navigation_fallout_current_sub_hover']['text-shadow']['color'],

						),

						## Element
						array(
							'type'		=>	'select',
							'style'		=>	'horizontal',
							'title'		=>	esc_html__('Shadow Direction','envision'),
							'id'		=>	cloudfw_sanitize('navigation_fallout_current_sub','text-shadow direction'),
							'value'		=>	$data['navigation_fallout_current_sub']['text-shadow']['direction'],
							'source'	=>	array(
								'-1'		=>	esc_html__('Top','envision'),
								'1'			=>	esc_html__('Bottom','envision'),
							),
							'width'		=>	120

						),


					)

				),


			)

		),

		array(
			'type'		=>	'module-set',
			'title'		=>	esc_html__('Mega Menu','envision'),
			'closable'	=>	true,
			'state'		=>	'opened',
			'data'		=>	array(

				## Module Item
				array(
					'type'		=>	'module',
					'ucode'		=>	'NAVIGATION MEGAMENU BACKGROUND',
					'title'		=>	esc_html__('Mega Menu Background','envision'),
					'layout'	=>	'float',
					'data'		=>	array(

						array(
							'type'		=>	'color',
							'style'		=>	'horizontal',
							'id'		=>	cloudfw_sanitize('navigation_megamenu_background','background-color'),
							'value'		=>	$data['navigation_megamenu_background']['background-color'],
						),

					)

				),

				## Module Item
				array(
					'type'		=>	'module',
					'ucode'		=>	'NAVIGATION MEGAMENU BACKGROUND',
					'title'		=>	esc_html__('Mega Menu Border','envision'),
					'layout'	=>	'float',
					'data'		=>	array(

						array(
							'type'		=>	'color',
							'style'		=>	'horizontal',
							'id'		=>	cloudfw_sanitize('navigation_megamenu_background','border-color'),
							'value'		=>	$data['navigation_megamenu_background']['border-color'],
						),

					)

				),

				## Module Item
				array(
					'type'		=>	'module',
					'ucode'		=>	'NAVIGATION MEGAMENU SEPERATOR',
					'title'		=>	esc_html__('Mega Menu Seperator Lines','envision'),
					'layout'	=>	'float',
					'data'		=>	array(

						array(
							'type'		=>	'color',
							'style'		=>	'horizontal',
							'id'		=>	cloudfw_sanitize('navigation_megamenu_seperator','border-color'),
							'value'		=>	$data['navigation_megamenu_seperator']['border-color'],
						),

					)

				),


				## Module Item
				array(
					'type'		=>	'module',
					'ucode'		=>	'NAVIGATION MEGAMENU LINK',
					'title'		=>	esc_html__('Text Color','envision'),
					'layout'	=>	'float',
					'data'		=>	array(

						array(
							'type'		=>	'color',
							'style'		=>	'horizontal',
							'id'		=>	cloudfw_sanitize('navigation_megamenu','color'),
							'value'		=>	$data['navigation_megamenu']['color'],
						),

					)

				),

				## Module Item
				array(
					'type'		=>	'module',
					'ucode'		=>	'NAVIGATION MEGAMENU LINK',
					'title'		=>	array(esc_html__('Link Color','envision'), esc_html__('Link Hover Color','envision')),
					'layout'	=>	'split',
					'data'		=>	array(

						array(
							'type'		=>	'color',
							'style'		=>	'horizontal',
							'id'		=>	cloudfw_sanitize('navigation_megamenu_link','color'),
							'value'		=>	$data['navigation_megamenu_link']['color'],
						),

						array(
							'type'		=>	'color',
							'style'		=>	'horizontal',
							'id'		=>	cloudfw_sanitize('navigation_megamenu_link_hover','color'),
							'value'		=>	$data['navigation_megamenu_link_hover']['color'],
						),

					)

				),

				## Module Item
				array(
					'type'		=>	'mini-section',
					'title'		=>	esc_html__('Mega Menu Item Style: Standard','envision'),
					'data'		=>	array(

						## Module Item
						array(
							'type'		=>	'module',
							'ucode'		=>	'NAVIGATION MEGAMENU STANDARD',
							'title'		=>	esc_html__('Standard','envision'),
							'layout'	=>	'float',
							'data'		=>	array(

								array(
									'type'		=>	'gradient',
									'title'		=>	esc_html__('Background Gradient','envision'),
									'id'		=>	cloudfw_sanitize('navigation_megamenu_standard_link','gradient'),
									'value'		=>	$data['navigation_megamenu_standard_link']['gradient'],
								),

								array(
									'type'		=>	'color',
									'style'		=>	'horizontal',
									'title'		=>	esc_html__('Text Color','envision'),
									'id'		=>	cloudfw_sanitize('navigation_megamenu_standard_link','color'),
									'value'		=>	$data['navigation_megamenu_standard_link']['color'],
								),

								## Element
								array(
									'type'		=>	'color',
									'style'		=>	'horizontal',
									'title'		=>	esc_html__('Text Shadow','envision'),
									'id'		=>	cloudfw_sanitize('navigation_megamenu_standard_link','text-shadow color'),
									'value'		=>	$data['navigation_megamenu_standard_link']['text-shadow']['color'],

								),

								## Element
								array(
									'type'		=>	'select',
									'style'		=>	'horizontal',
									'title'		=>	esc_html__('Shadow Direction','envision'),
									'id'		=>	cloudfw_sanitize('navigation_megamenu_standard_link','text-shadow direction'),
									'value'		=>	$data['navigation_megamenu_standard_link']['text-shadow']['direction'],
									'source'	=>	array(
										'-1'		=>	esc_html__('Top','envision'),
										'1'			=>	esc_html__('Bottom','envision'),
									),
									'width'		=>	120

								),


							)

						),

						## Module Item
						array(
							'type'		=>	'module',
							'ucode'		=>	'NAVIGATION MEGAMENU STANDARD SEPERATOR',
							'title'		=>	esc_html__('Standard Border Bottom','envision'),
							'layout'	=>	'float',
							'data'		=>	array(

								array(
									'type'		=>	'color',
									'style'		=>	'horizontal',
									'id'		=>	cloudfw_sanitize('navigation_megamenu_standard_link','border-color'),
									'value'		=>	$data['navigation_megamenu_standard_link']['border-color'],
								),

							)

						),

						## Module Item
						array(
							'type'		=>	'module',
							'ucode'		=>	'NAVIGATION MEGAMENU STANDARD',
							'title'		=>	esc_html__('Standard Hover','envision'),
							'layout'	=>	'float',
							'data'		=>	array(

								array(
									'type'		=>	'gradient',
									'title'		=>	esc_html__('Background Gradient','envision'),
									'id'		=>	cloudfw_sanitize('navigation_megamenu_standard_link_hover','gradient'),
									'value'		=>	$data['navigation_megamenu_standard_link_hover']['gradient'],
								),

								array(
									'type'		=>	'color',
									'style'		=>	'horizontal',
									'title'		=>	esc_html__('Text Color','envision'),
									'id'		=>	cloudfw_sanitize('navigation_megamenu_standard_link_hover','color'),
									'value'		=>	$data['navigation_megamenu_standard_link_hover']['color'],
								),

								## Element
								array(
									'type'		=>	'color',
									'style'		=>	'horizontal',
									'title'		=>	esc_html__('Text Shadow','envision'),
									'id'		=>	cloudfw_sanitize('navigation_megamenu_standard_link_hover','text-shadow color'),
									'value'		=>	$data['navigation_megamenu_standard_link_hover']['text-shadow']['color'],

								),

								## Element
								array(
									'type'		=>	'select',
									'style'		=>	'horizontal',
									'title'		=>	esc_html__('Shadow Direction','envision'),
									'id'		=>	cloudfw_sanitize('navigation_megamenu_standard_link_hover','text-shadow direction'),
									'value'		=>	$data['navigation_megamenu_standard_link_hover']['text-shadow']['direction'],
									'source'	=>	array(
										'-1'		=>	esc_html__('Top','envision'),
										'1'			=>	esc_html__('Bottom','envision'),
									),
									'width'		=>	120

								),


							)

						),

						## Module Item
						array(
							'type'		=>	'module',
							'ucode'		=>	'NAVIGATION MEGAMENU STANDARD',
							'title'		=>	esc_html__('Standard (Active Item)','envision'),
							'layout'	=>	'float',
							'data'		=>	array(

								array(
									'type'		=>	'gradient',
									'title'		=>	esc_html__('Background Gradient','envision'),
									'id'		=>	cloudfw_sanitize('navigation_megamenu_standard_current_link','gradient'),
									'value'		=>	$data['navigation_megamenu_standard_current_link']['gradient'],
								),

								array(
									'type'		=>	'color',
									'style'		=>	'horizontal',
									'title'		=>	esc_html__('Text Color','envision'),
									'id'		=>	cloudfw_sanitize('navigation_megamenu_standard_current_link','color'),
									'value'		=>	$data['navigation_megamenu_standard_current_link']['color'],
								),

								## Element
								array(
									'type'		=>	'color',
									'style'		=>	'horizontal',
									'title'		=>	esc_html__('Text Shadow','envision'),
									'id'		=>	cloudfw_sanitize('navigation_megamenu_standard_current_link','text-shadow color'),
									'value'		=>	$data['navigation_megamenu_standard_current_link']['text-shadow']['color'],

								),

								## Element
								array(
									'type'		=>	'select',
									'style'		=>	'horizontal',
									'title'		=>	esc_html__('Shadow Direction','envision'),
									'id'		=>	cloudfw_sanitize('navigation_megamenu_standard_current_link','text-shadow direction'),
									'value'		=>	$data['navigation_megamenu_standard_current_link']['text-shadow']['direction'],
									'source'	=>	array(
										'-1'		=>	esc_html__('Top','envision'),
										'1'			=>	esc_html__('Bottom','envision'),
									),
									'width'		=>	120

								),


							)

						),


						## Module Item
						array(
							'type'		=>	'module',
							'ucode'		=>	'NAVIGATION MEGAMENU STANDARD',
							'title'		=>	esc_html__('Standard (Active Item) Hover','envision'),
							'layout'	=>	'float',
							'data'		=>	array(

								array(
									'type'		=>	'gradient',
									'title'		=>	esc_html__('Background Gradient','envision'),
									'id'		=>	cloudfw_sanitize('navigation_megamenu_standard_current_link_hover','gradient'),
									'value'		=>	$data['navigation_megamenu_standard_current_link_hover']['gradient'],
								),

								array(
									'type'		=>	'color',
									'style'		=>	'horizontal',
									'title'		=>	esc_html__('Text Color','envision'),
									'id'		=>	cloudfw_sanitize('navigation_megamenu_standard_current_link_hover','color'),
									'value'		=>	$data['navigation_megamenu_standard_current_link_hover']['color'],
								),

								## Element
								array(
									'type'		=>	'color',
									'style'		=>	'horizontal',
									'title'		=>	esc_html__('Text Shadow','envision'),
									'id'		=>	cloudfw_sanitize('navigation_megamenu_standard_current_link_hover','text-shadow color'),
									'value'		=>	$data['navigation_megamenu_standard_current_link_hover']['text-shadow']['color'],

								),

								## Element
								array(
									'type'		=>	'select',
									'style'		=>	'horizontal',
									'title'		=>	esc_html__('Shadow Direction','envision'),
									'id'		=>	cloudfw_sanitize('navigation_megamenu_standard_current_link_hover','text-shadow direction'),
									'value'		=>	$data['navigation_megamenu_standard_current_link_hover']['text-shadow']['direction'],
									'source'	=>	array(
										'-1'		=>	esc_html__('Top','envision'),
										'1'			=>	esc_html__('Bottom','envision'),
									),
									'width'		=>	120

								),


							)

						),

					)

				),

				## Module Item
				array(
					'type'		=>	'mini-section',
					'title'		=>	esc_html__('Mega Menu Item Style: Big Titles','envision'),
					'data'		=>	array(

						## Module Item
						array(
							'type'		=>	'module',
							'ucode'		=>	'NAVIGATION MEGAMENU BIG TITLE',
							'title'		=>	esc_html__('Big Titles','envision'),
							'layout'	=>	'float',
							'data'		=>	array(

								array(
									'type'		=>	'gradient',
									'title'		=>	esc_html__('Background Gradient','envision'),
									'id'		=>	cloudfw_sanitize('navigation_megamenu_big_title','gradient'),
									'value'		=>	$data['navigation_megamenu_big_title']['gradient'],
								),

								array(
									'type'		=>	'color',
									'style'		=>	'horizontal',
									'title'		=>	esc_html__('Text Color','envision'),
									'id'		=>	cloudfw_sanitize('navigation_megamenu_big_title','color'),
									'value'		=>	$data['navigation_megamenu_big_title']['color'],
								),

								## Element
								array(
									'type'		=>	'color',
									'style'		=>	'horizontal',
									'title'		=>	esc_html__('Text Shadow','envision'),
									'id'		=>	cloudfw_sanitize('navigation_megamenu_big_title','text-shadow color'),
									'value'		=>	$data['navigation_megamenu_big_title']['text-shadow']['color'],

								),

								## Element
								array(
									'type'		=>	'select',
									'style'		=>	'horizontal',
									'title'		=>	esc_html__('Shadow Direction','envision'),
									'id'		=>	cloudfw_sanitize('navigation_megamenu_big_title','text-shadow direction'),
									'value'		=>	$data['navigation_megamenu_big_title']['text-shadow']['direction'],
									'source'	=>	array(
										'-1'		=>	esc_html__('Top','envision'),
										'1'			=>	esc_html__('Bottom','envision'),
									),
									'width'		=>	120

								),


							)

						),

						## Module Item
						array(
							'type'		=>	'module',
							'ucode'		=>	'NAVIGATION MEGAMENU BIG TITLE SEPERATOR',
							'title'		=>	esc_html__('Big Titles Border Bottom','envision'),
							'layout'	=>	'float',
							'data'		=>	array(

								array(
									'type'		=>	'color',
									'style'		=>	'horizontal',
									'id'		=>	cloudfw_sanitize('navigation_megamenu_big_title','border-color'),
									'value'		=>	$data['navigation_megamenu_big_title']['border-color'],
								),

							)

						),

						## Module Item
						array(
							'type'		=>	'module',
							'ucode'		=>	'NAVIGATION MEGAMENU BIG TITLE',
							'title'		=>	esc_html__('Big Titles Hover','envision'),
							'layout'	=>	'float',
							'data'		=>	array(

								array(
									'type'		=>	'gradient',
									'title'		=>	esc_html__('Background Gradient','envision'),
									'id'		=>	cloudfw_sanitize('navigation_megamenu_big_title_hover','gradient'),
									'value'		=>	$data['navigation_megamenu_big_title_hover']['gradient'],
								),

								array(
									'type'		=>	'color',
									'style'		=>	'horizontal',
									'title'		=>	esc_html__('Text Color','envision'),
									'id'		=>	cloudfw_sanitize('navigation_megamenu_big_title_hover','color'),
									'value'		=>	$data['navigation_megamenu_big_title_hover']['color'],
								),

								## Element
								array(
									'type'		=>	'color',
									'style'		=>	'horizontal',
									'title'		=>	esc_html__('Text Shadow','envision'),
									'id'		=>	cloudfw_sanitize('navigation_megamenu_big_title_hover','text-shadow color'),
									'value'		=>	$data['navigation_megamenu_big_title_hover']['text-shadow']['color'],

								),

								## Element
								array(
									'type'		=>	'select',
									'style'		=>	'horizontal',
									'title'		=>	esc_html__('Shadow Direction','envision'),
									'id'		=>	cloudfw_sanitize('navigation_megamenu_big_title_hover','text-shadow direction'),
									'value'		=>	$data['navigation_megamenu_big_title_hover']['text-shadow']['direction'],
									'source'	=>	array(
										'-1'		=>	esc_html__('Top','envision'),
										'1'			=>	esc_html__('Bottom','envision'),
									),
									'width'		=>	120

								),


							)

						),

					)

				),

			)

		),

		array(
			'type'		=>	'module-set',
			'title'		=>	esc_html__('Mobile Menu','envision'),
			'closable'	=>	true,
			'state'		=>	'opened',
			'data'		=>	array(


				## Module Item
				array(
					'type'		=>	'module',
					'ucode'		=>	'NAVIGATION MOBILE TOGGLE',
					'title'		=>	esc_html__('Toggle Colors','envision'),
					'layout'	=>	'float',
					'data'		=>	array(
						## Element
						array(
							'type'		=>	'gradient',
							'title'		=>	esc_html__('Background Gradient','envision'),
							'id'		=>	cloudfw_sanitize('navigation_mobile_toggle','gradient'),
							'value'		=>	$data['navigation_mobile_toggle']['gradient'],
						),

						## Element
						array(
							'type'		=>	'color',
							'style'		=>	'horizontal',
							'title'		=>	esc_html__('Text Color','envision'),
							'id'		=>	cloudfw_sanitize('navigation_mobile_toggle','color'),
							'value'		=>	$data['navigation_mobile_toggle']['color'],

						),

						## Element
						array(
							'type'		=>	'color',
							'style'		=>	'horizontal',
							'title'		=>	esc_html__('Text Shadow','envision'),
							'id'		=>	cloudfw_sanitize('navigation_mobile_toggle','text-shadow color'),
							'value'		=>	$data['navigation_mobile_toggle']['text-shadow']['color'],

						),

						## Element
						array(
							'type'		=>	'select',
							'style'		=>	'horizontal',
							'title'		=>	esc_html__('Shadow Direction','envision'),
							'id'		=>	cloudfw_sanitize('navigation_mobile_toggle','text-shadow direction'),
							'value'		=>	$data['navigation_mobile_toggle']['text-shadow']['direction'],
							'source'	=>	array(
								'-1'		=>	esc_html__('Top','envision'),
								'1'			=>	esc_html__('Bottom','envision'),
							),
							'width'		=>	120

						),

					)

				),

				## Module Item
				array(
					'type'		=>	'module',
					'ucode'		=>	'NAVIGATION MOBILE TOGGLE',
					'title'		=>	esc_html__('Toggle Button Border','envision'),
					'layout'	=>	'float',
					'data'		=>	array(
						## Element
						array(
							'type'		=>	'color',
							'style'		=>	'horizontal',
							'id'		=>	cloudfw_sanitize('navigation_mobile_toggle','border-color'),
							'value'		=>	$data['navigation_mobile_toggle']['border-color'],
						),


					)

				),

				## Module Item
				array(
					'type'		=>	'mini-section',
					'title'		=>	esc_html__('Mobile Menu Toogle Hover','envision'),
					'data'		=>	array(

						## Module Item
						array(
							'type'		=>	'module',
							'ucode'		=>	'NAVIGATION MOBILE TOGGLE',
							'title'		=>	esc_html__('Toggle Hover Colors','envision'),
							'layout'	=>	'float',
							'data'		=>	array(
								## Element
								array(
									'type'		=>	'gradient',
									'title'		=>	esc_html__('Background Gradient','envision'),
									'id'		=>	cloudfw_sanitize('navigation_mobile_toggle_hover','gradient'),
									'value'		=>	$data['navigation_mobile_toggle_hover']['gradient'],
								),

								## Element
								array(
									'type'		=>	'color',
									'style'		=>	'horizontal',
									'title'		=>	esc_html__('Text Color','envision'),
									'id'		=>	cloudfw_sanitize('navigation_mobile_toggle_hover','color'),
									'value'		=>	$data['navigation_mobile_toggle_hover']['color'],

								),

								## Element
								array(
									'type'		=>	'color',
									'style'		=>	'horizontal',
									'title'		=>	esc_html__('Text Shadow','envision'),
									'id'		=>	cloudfw_sanitize('navigation_mobile_toggle_hover','text-shadow color'),
									'value'		=>	$data['navigation_mobile_toggle_hover']['text-shadow']['color'],

								),

								## Element
								array(
									'type'		=>	'select',
									'style'		=>	'horizontal',
									'title'		=>	esc_html__('Shadow Direction','envision'),
									'id'		=>	cloudfw_sanitize('navigation_mobile_toggle_hover','text-shadow direction'),
									'value'		=>	$data['navigation_mobile_toggle_hover']['text-shadow']['direction'],
									'source'	=>	array(
										'-1'		=>	esc_html__('Top','envision'),
										'1'			=>	esc_html__('Bottom','envision'),
									),
									'width'		=>	120

								),

							)

						),

						## Module Item
						array(
							'type'		=>	'module',
							'ucode'		=>	'NAVIGATION MOBILE TOGGLE',
							'title'		=>	esc_html__('Toggle Hover Border','envision'),
							'layout'	=>	'float',
							'data'		=>	array(
								## Element
								array(
									'type'		=>	'color',
									'style'		=>	'horizontal',
									'id'		=>	cloudfw_sanitize('navigation_mobile_toggle_hover','border-color'),
									'value'		=>	$data['navigation_mobile_toggle_hover']['border-color'],
								),


							)

						),


					)

				),


				## Module Item
				array(
					'type'		=>	'mini-section',
					'title'		=>	esc_html__('Mobile Menu Items','envision'),
					'data'		=>	array(


						## Module Item
						array(
							'type'		=>	'module',
							'ucode'		=>	'NAVIGATION MOBILE TOGGLE',
							'title'		=>	esc_html__('Separator Line for Menu Items','envision'),
							'layout'	=>	'float',
							'data'		=>	array(
								## Element
								array(
									'type'		=>	'color',
									'style'		=>	'horizontal',
									'id'		=>	cloudfw_sanitize('navigation_mobile_toggle_border','border-color'),
									'value'		=>	$data['navigation_mobile_toggle_border']['border-color'],
								),

							)

						),


						## Module Item
						array(
							'type'		=>	'module',
							'ucode'		=>	'NAVIGATION LINK',
							'title'		=>	esc_html__('Menu Item Background (Normal)','envision'),
							'data'		=>	array(
								## Element
								array(
									'type'		=>	'gradient',
									'title'		=>	esc_html__('Background Gradient','envision'),
									'id'		=>	cloudfw_sanitize('navigation_level_0_mobile','gradient'),
									'value'		=>	$data['navigation_level_0_mobile']['gradient'],
								),

							)

						),

						## Module Item
						array(
							'type'		=>	'text-shadow-kit',
							'merge'		=>	'module',
							'title'		=>	esc_html__('Menu Item Texts (Normal)','envision'),
							'id'		=>	cloudfw_sanitize('navigation_level_0_mobile'),
							'value'		=>	$data['navigation_level_0_mobile'],
							'ucode'		=>	'NAVIGATION LINK',
						),

						## Module Item
						array(
							'type'		=>	'border-radius-kit',
							'merge'		=>	'module',
							'title'		=>	esc_html__('Menu Item Border Radius (Normal)','envision'),
							'id'		=>	cloudfw_sanitize('navigation_level_0_mobile_border_radius'),
							'value'		=>	$data['navigation_level_0_mobile_border_radius'],
							'ucode'		=>	'NAVIGATION BORDER RADIUS',
						),

						## Module Item
						array(
							'type'		=>	'module',
							'ucode'		=>	'NAVIGATION LINK',
							'title'		=>	esc_html__('Menu Item Background (Hover)','envision'),
							'data'		=>	array(
								## Element
								array(
									'type'		=>	'gradient',
									'title'		=>	esc_html__('Background Gradient','envision'),
									'id'		=>	cloudfw_sanitize('navigation_level_0_mobile_hover2','gradient'),
									'value'		=>	$data['navigation_level_0_mobile_hover2']['gradient'],
								),

							)

						),

						## Module Item
						array(
							'type'		=>	'text-shadow-kit',
							'merge'		=>	'module',
							'title'		=>	esc_html__('Menu Item Texts (Hover)','envision'),
							'id'		=>	cloudfw_sanitize('navigation_level_0_mobile_hover2'),
							'value'		=>	$data['navigation_level_0_mobile_hover2'],
							'ucode'		=>	'NAVIGATION LINK',
						),


						## Module Item
						array(
							'type'		=>	'module',
							'ucode'		=>	'NAVIGATION LINK LINE',
							'title'		=>	esc_html__('Menu Item Bottom Border','envision'),
							'layout'	=>	'float',
							'data'		=>	array(

								array(
									'type'		=>	'color',
									'style'		=>	'horizontal',
									'id'		=>	cloudfw_sanitize('navigation_level_0_mobile_active_border','border-color'),
									'value'		=>	$data['navigation_level_0_mobile_active_border']['border-color'],
								),


							)

						),

						## Module Item
						array(
							'type'		=>	'module',
							'ucode'		=>	'NAVIGATION LINK',
							'title'		=>	esc_html__('Menu Item Background (Active Item)','envision'),
							'data'		=>	array(
								## Element
								array(
									'type'		=>	'gradient',
									'title'		=>	esc_html__('Background Gradient','envision'),
									'id'		=>	cloudfw_sanitize('navigation_level_0_mobile_current_item','gradient'),
									'value'		=>	$data['navigation_level_0_mobile_current_item']['gradient'],
								),

							)

						),

						## Module Item
						array(
							'type'		=>	'text-shadow-kit',
							'merge'		=>	'module',
							'title'		=>	esc_html__('Menu Item Texts (Active Item)','envision'),
							'id'		=>	cloudfw_sanitize('navigation_level_0_mobile_current_item'),
							'value'		=>	$data['navigation_level_0_mobile_current_item'],
							'ucode'		=>	'NAVIGATION LINK',
						),

					)

				),

			)

		),

	)

);
