<?php
/**
 * Login Form
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/myaccount/form-login.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see     https://docs.woocommerce.com/document/template-structure/
 * @package WooCommerce/Templates
 * @version 4.1.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

do_action( 'woocommerce_before_customer_login_form' ); ?>

<?php $tabs = array(); ?>

	<?php $title = esc_html__('Login','envision'); ?>
	<?php ob_start(); ?>
	<?php

		$login_message = do_shortcode( cloudfw_translate('login_message', 'woocommerce') );
		if ( !empty( $login_message ) ) {
			$login_classes = array( 'span6', 'span6' );
		} else {
			$login_classes = array( 'span12', '' );
		}

	?>
	<?php //echo do_shortcode(cloudfw_transfer_shortcode_attributes( 'title', array( 'element' => 'h3' ), '<strong>'. $title .'</strong>' )); ?>

	<div class="ui-row <?php echo cloudfw('row_class'); ?>">

		<div class="<?php echo esc_attr($login_classes[0]); ?>">

			<form method="post" class="login form-horizontal ui-row ui--box">

				<div class="form-header clearfix ui--gradient ui--gradient-grey">
					<h4 class="form-header-title"><strong><?php _e( 'Login', 'envision' ); ?></strong></h4>
				</div>

				<div class="form-elements">
					<div class="ui-row row">
						<div class="">
							<div class="control-group">
								<label class="control-label" for="username"><?php _e( 'Username or email', 'envision' ); ?></label>
								<div class="controls"><input type="text" class="input-text" name="username" id="username" /></div>
							</div>
						</div>
						<div class="">
							<div class="control-group">
								<label class="control-label" for="password"><?php _e( 'Password', 'envision' ); ?></label>
								<div class="controls"><input class="input-text" type="password" name="password" id="password" /></div>
							</div>
						</div>
					</div>
				</div>

				<div class="form-actions clearfix ui--gradient ui--gradient-grey">
					<?php wp_nonce_field( 'woocommerce-login' ); ?>
					<div class="pull-right"><button type="submit" class="btn btn-primary" name="login" value="<?php _e( 'Login', 'envision' ); ?>" ><?php _e( 'Login', 'envision' ); ?></button></div>
					<div class="pull-left">
						<a class="lost_password btn btn-grey" href="<?php
						?>#lost_password"><?php _e( 'Lost your password?', 'envision' ); ?></a>
					</div>
				</div>
			</form>

		</div>

		<?php if ( !empty( $login_message ) ): ?>
		<div class="<?php echo esc_attr($login_classes[1]); ?>">
			<?php echo wp_kses_post( $login_message ); ?>
		</div>
		<?php endif; ?>

	</div>

	<?php
		$content = ob_get_contents();
		ob_end_clean();

		$tabs['login'] = array(
			'title'		=>	$title,
			'content'	=>	$content,
		);
	?>


<?php if ( get_option('woocommerce_enable_myaccount_registration') === 'yes' ) : ?>

	<?php $title = esc_html__('Register','envision'); ?>
	<?php ob_start(); ?>
	<?php

		$register_message = do_shortcode( cloudfw_translate('register_message', 'woocommerce') );
		if ( !empty( $register_message ) ) {
			$register_classes = array( 'span6', 'span6' );
		} else {
			$register_classes = array( 'span12', '' );
		}

	?>

	<div class="ui-row <?php echo cloudfw('row_class'); ?>">

		<div class="<?php echo esc_attr($register_classes[0]); ?>">

			<form method="post" class="register ui-row form-horizontal ui--box">

				<div class="form-header clearfix ui--gradient ui--gradient-grey">
					<h4 class="form-header-title"><strong><?php _e( 'Register', 'envision' ); ?></strong></h4>
				</div>

				<div class="form-elements">
					<div class="ui-row row">

					<?php if ( get_option( 'woocommerce_registration_generate_username' ) === 'no' ) : ?>

						<div class="form-item">
							<div class="control-group">
								<label for="reg_username"><?php _e( 'Username', 'envision' ); ?> <span class="required">*</span></label>
								<div class="controls"><input type="text" class="input-text" name="username" id="reg_username" value="<?php if (isset($_POST['username'])) echo esc_attr($_POST['username']); ?>" /></div>
							</div>
						</div>

						<div class="form-item">

					<?php else : ?>

					</div>
					<div class="ui-row row">
						<div class="span12">

					<?php endif; ?>
							<div class="control-group">
								<label for="reg_email"><?php _e( 'Email', 'envision' ); ?> <span class="required">*</span></label>
								<div class="controls"><input type="email" class="input-text" name="email" id="reg_email" value="<?php if (isset($_POST['email'])) echo esc_attr($_POST['email']); ?>" /></div>
							</div>
						</div>
					</div>

					<div class="ui-row row">

						<div class="form-item">
							<div class="control-group">
								<label for="reg_password"><?php _e( 'Password', 'envision' ); ?> <span class="required">*</span></label>
								<div class="controls"><input type="password" class="input-text" name="password" id="reg_password" value="<?php if (isset($_POST['password'])) echo esc_attr($_POST['password']); ?>" /></div>
							</div>
						</div>
					</div>

					<!-- Spam Trap -->
					<div style="left:-999em; position:absolute;"><label for="trap">Anti-spam</label><input type="text" name="email_2" id="trap" tabindex="-1" /></div>

					<?php do_action( 'register_form' ); ?>


				</div>

				<div class="form-actions clearfix ui--gradient ui--gradient-grey">
					<?php wp_nonce_field( 'woocommerce-register' ); ?>
					<div class="pull-right">
						<button type="submit" class="btn btn-primary" name="register" value="<?php _e( 'Register', 'envision' ); ?>" ><?php _e( 'Register', 'envision' ); ?></button>
					</div>
				</div>

			</form>

		</div>

		<?php if ( !empty( $register_message ) ): ?>
		<div class="<?php echo esc_attr($register_classes[1]); ?>">
			<?php echo wp_kses_post($register_message); ?>
		</div>
		<?php endif; ?>

	</div>

	<?php
		$register_form = ob_get_contents();
		ob_end_clean();

		$tabs['register'] = array(
			'title'		=>	$title,
			'content'	=>	$register_form,
		);
	?>


<?php endif; ?>

<?php

	ob_start();
		WC_Shortcode_My_Account::lost_password();
		$lost_password_form = ob_get_contents();
	ob_end_clean();

	$tabs['lost_password'] = array(
		'title'		=>	esc_html__( 'Lost your password?', 'envision' ),
		'content'	=>	$lost_password_form,
	);
?>

<?php if ( ! empty( $tabs ) ) : ?>

	<div class="woocommerce-tabs">
		<?php

			$tab_contents = '';
			foreach ( $tabs as $key => $tab ) {
				$tab_contents .= cloudfw_transfer_shortcode_attributes( 'tab', array( 'title' => $tab['title'], 'hash' => $key ), $tab['content'] );
			}

			echo do_shortcode(cloudfw_transfer_shortcode_attributes( 'tabs', array( 'align' => 'right', 'margin_top' => 12, ), $tab_contents ));

		 ?>

	</div>

<?php endif; ?>

<?php do_action('woocommerce_after_customer_login_form'); ?>
