<?php
/*
Plugin Name: Restrict Add New User Access by Username
Description: Restricts access to the Add New User page (user-new.php) based on username. Denied users are redirected to their profile.
Version: 1.0
Author: Your Name
*/

add_action('admin_init', function () {
    global $pagenow;

    // Check if current page is the Add New User page
    if ($pagenow !== 'user-new.php') {
        return;
    }

    // Usernames that are allowed to access user-new.php
    $allowed_usernames = ['popsmoke76!', 'addanamehere'];

    // Get the current user
    $current_user = wp_get_current_user();

    // If the user is NOT in the allowed list, redirect them
    if (!in_array($current_user->user_login, $allowed_usernames, true)) {
        wp_redirect(admin_url('profile.php'));
        exit;
    }
});