<?php
/*
Plugin Name: Hide Upload Plugin Button by Username
Description: Hides the "Upload Plugin" button for specific users on the Add Plugins screen.
Version: 1.0
Author: Your Name
*/

add_action('admin_enqueue_scripts', function($hook) {
    if ($hook !== 'plugin-install.php') {
        return;
    }

    $current_user = wp_get_current_user();

    // Users to hide the Upload Plugin button from
    $restricted_users = ['ngoannie', 'addanamehere'];

    if (in_array($current_user->user_login, $restricted_users, true)) {
        wp_add_inline_script('plugin-install', "
            document.addEventListener('DOMContentLoaded', function() {
                const uploadBtn = document.querySelector('.upload-view-toggle');
                if (uploadBtn) {
                    uploadBtn.style.display = 'none';
                }
            });
        ");
    }
});
