<?php // Reset Settings

if (!defined('ABSPATH')) exit;

function banhammer_admin_notices() {
	
	$screen = get_current_screen();
	
	if (!property_exists($screen, 'id')) return;
	
	if ($screen->id === 'toplevel_page_banhammer') {
		
		if (isset($_GET['banhammer-reset-options'])) {
			
			if ($_GET['banhammer-reset-options'] === 'true') : ?>
				
				<div class="notice notice-success is-dismissible"><p><strong><?php esc_html_e('Default options restored.', 'bbq'); ?></strong></p></div>
				
			<?php else : ?>
				
				<div class="notice notice-info is-dismissible"><p><strong><?php esc_html_e('No changes made to options.', 'bbq'); ?></strong></p></div>
				
			<?php endif;
			
		}
		
	} elseif ($screen->id === 'banhammer_page_banhammer-tower') {
		
		if (isset($_GET['banhammer-add-target'])) {
			
			if ($_GET['banhammer-add-target'] === 'true') : ?>
				
				<div class="notice notice-success is-dismissible"><p><strong><?php esc_html_e('Target added to Tower.', 'bbq'); ?></strong></p></div>
				
			<?php else : ?>
				
				<div class="notice notice-info is-dismissible"><p><strong><?php esc_html_e('Target already exists in Tower.', 'bbq'); ?></strong></p></div>
				
			<?php endif;
			
		}
		
	}
	
}

function banhammer_reset_options() {
	
	if (isset($_GET['banhammer-reset-options']) && wp_verify_nonce($_GET['banhammer-reset-options'], 'banhammer_reset_options')) {
		
		if (!current_user_can('manage_options')) exit;
		
		global $BanhammerWP;
		
		$armory = $BanhammerWP->armory();
		
		$options = $BanhammerWP->options();
		
		$armory_update = update_option('banhammer_armory', $armory);
		
		$options_update = update_option('banhammer_settings', $options);
		
		$result = 'false';
		
		if ($armory_update || $options_update) $result = 'true';
		
		$location = admin_url('admin.php?page=banhammer&banhammer-reset-options='. $result);
		
		wp_redirect(esc_url_raw($location));
		
		exit;
		
	}
	
}

function banhammer_remove_query_args($params) {
	
	if (!is_null($params)) $params[] = 'banhammer-reset-options';
	
	return $params;
	
}
