<?php
/*
Plugin Name: Blocker. Plugin
Plugin URI: https://premium.divcoder.com/
Description: Block everything you do not want. Just with one click!
Author: Divcoder
Version: 1.6.0
Author URI: https://premium.divcoder.com
Authoras URI: https://premium.divcoder.com
Domain Path: /languages
*/

if ( !function_exists( 'add_action' ) ) {
    echo 'Code is poetry.';
    exit;
}

//Plugin DIR URL
define( 'DADB_URL', plugin_dir_url( __FILE__ ) );
//Plugin DIR Path
define( 'DADB_DIR', plugin_dir_path( __FILE__ ) );

//Admin Styles
add_action( 'admin_init', 'dadb_echo_css' );

function dadb_echo_css() {
	//Add CSS Style for Admin Panel
   wp_enqueue_style( 'dadb-style', DADB_URL."admin/assets/css/style.css",array(), "1.0.0" );
}

/*
* Load Admin Settings
*/
include DADB_DIR ."admin/index.php";

/*
* Load Functions
*/
include DADB_DIR ."functions/DADB-functions.php";
include DADB_DIR ."functions/DADB-widget.php";

/**
 * Load plugin textdomain.
 *
 * @since 1.0.0
 */
function DADB_language() {
  load_plugin_textdomain( 'dadb-plugin', false, basename( dirname( __FILE__ ) ) . '/languages' ); 
}

//Load Plugin Functions
add_action( 'plugins_loaded', 'DADB_language' );

/*
* Default Options for Plugin
*/
function DADB_activation() {

	add_option("dadb_start","0");
	add_option("dadb_logs","0");
	add_option("dadb_messag","0");
	add_option("dadb_savelog","");
	
	add_option("dadb_start_dash","0");
	add_option("dadb_start_stat","1");
	
	add_option("dadb_bu","1");
	add_option("dadb_nn","1");
	add_option("dadb_rn","1");
	add_option("dadb_fn","1");
	
	add_option("dadb_vpnproxy","0");
	add_option("dadb_maliip","0");
	add_option("dadb_malimail","0");
	add_option("dadb_malicomm","0");
	add_option("dadb_torip","0");
	add_option("dadb_fakesearch","0");
	add_option("dadb_fakeuser","0");
	add_option("dadb_botacc","0");
	
	add_option("dadb_get_white_list","");
	add_option("dadb_get_white_ip_list","");
	add_option("dadb_get_black_ip_list","");
	
	add_option("dadb_get_ua_list","");
	add_option("dadb_get_black_cc_list","");
	add_option("dadb_get_black_isp_list","");
	
	add_option("dadb_get_bad_mail","");

	
}

//Register Options
register_activation_hook( __FILE__, 'DADB_activation' );

// Plugin WP-Admin Settings Text
add_filter('plugin_action_links_'.plugin_basename(__FILE__), 'dadb_plugin_page');

function dadb_plugin_page( $links ) {
    $links[] = '<a href="' . admin_url( 'admin.php?page=DADB_plugin_dashboard' ) . '">' . __('Settings') . '</a>';
    return $links;
}