<?php

/*
 * Plugin Name: Socialbars
 * Plugin URI: http://wptation.com
 * Description:
 * Version: 1.0
 * Author: Orkun Gürsel
 * Author URI: http://wptation.com
 * Shortcode:
 * Attributes:
 */

define( 'CLOUDFW_SOCIAL_SVG_FOLDER', path_join( dirname(__FILE__), 'svg' ) );

add_filter( 'cloudfw_socialbar_services', 'cloudfw_add_custom_icons_to_services' );

function cloudfw_add_custom_icons_to_services( $list ) {
	$icons = cloudfw_get_custom_icons();

	if ( ! empty( $icons ) ) {
		foreach( $icons as $icon ) {
			$id = !empty($icon['id']) ? $icon['id'] : null;
			$svg = !empty($icon['svg']) ? preg_replace( '/fill=["|\']([^\s|\/>]+)["|\']/m', '', $icon['svg']) : null;

			if ( !empty( $svg ) ) {
				$name = !empty($icon['name']) ? $icon['name'] : null;
				$color = !empty($icon['color']) ? '#'. str_replace('#', '', $icon['color']) : null;
				$bg = !empty($icon['bg']) ? '#'. str_replace('#', '', $icon['bg']) : null;

				$list[ $id ] = array(
					'title' => $name,
					'code' => $svg,
					'color' => $color,
					'bg-color' => $bg,
				);
			}
		}
	}

	return $list;
}

function cloudfw_socialbar_services(){
	return apply_filters( 'cloudfw_socialbar_services', array(
		'facebook'    => array( 'title' => esc_attr__( 'Facebook','envision-core' ) ),
		'twitter'     => array( 'title' => esc_attr__( 'Twitter','envision-core' ) ),
		'twitter-alt' => array( 'title' => esc_attr__( 'Twitter Alternative','envision-core' ), 'alt' => esc_attr__( 'Twitter','envision-core' ) ),
		'flickr'      => array( 'title' => esc_attr__( 'Flickr','envision-core' ) ),
		'linkedin'    => array( 'title' => esc_attr__( 'Linkedin','envision-core' ) ),
		'google'      => array( 'title' => esc_attr__( 'Google','envision-core' ) ),
		'googleplus'  => array( 'title' => esc_attr__( 'Google Plus','envision-core' ) ),
		'googledrive' => array( 'title' => esc_attr__( 'Google Drive','envision-core' ) ),
		'digg'        => array( 'title' => esc_attr__( 'Digg','envision-core' ) ),
		'dribbble'    => array( 'title' => esc_attr__( 'Dribbble','envision-core' ) ),
		'dropbox'     => array( 'title' => esc_attr__( 'Dropbox','envision-core' ) ),
		'myspace'     => array( 'title' => esc_attr__( 'Myspace','envision-core' ) ),
		'paypal'      => array( 'title' => esc_attr__( 'Paypal','envision-core' ) ),
		'pinterest'   => array( 'title' => esc_attr__( 'Pinterest','envision-core' ) ),
		'reddit'      => array( 'title' => esc_attr__( 'Reddit','envision-core' ) ),
		'skype'       => array( 'title' => esc_attr__( 'Skype','envision-core' ) ),
		'stumbleupon' => array( 'title' => esc_attr__( 'Stumbleupon','envision-core' ) ),
		'tumblr'      => array( 'title' => esc_attr__( 'Tumblr','envision-core' ) ),
		'tripadvisor' => array( 'title' => esc_attr__( 'Trip Advisor','envision-core' ) ),
		'homeadvisor' => array( 'title' => esc_attr__( 'Home Advisor','envision-core' ) ),
		'bbb'         => array( 'title' => esc_attr__( 'Better Business Bureau','envision-core' ) ),
		'vimeo'       => array( 'title' => esc_attr__( 'Vimeo','envision-core' ) ),
		'wordpress'   => array( 'title' => esc_attr__( 'Wordpress','envision-core' ) ),
		'yahoo'       => array( 'title' => esc_attr__( 'Yahoo','envision-core' ) ),
		'youtube'     => array( 'title' => esc_attr__( 'Youtube','envision-core' ) ),
		'github'      => array( 'title' => esc_attr__( 'Github','envision-core' ) ),
		'behance'     => array( 'title' => esc_attr__( 'Behance','envision-core' ) ),
		'yelp'        => array( 'title' => esc_attr__( 'Yelp','envision-core' ) ),
		'instagram'   => array( 'title' => esc_attr__( 'Instagram','envision-core' ) ),
		'foursquare'  => array( 'title' => esc_attr__( 'Foursquare','envision-core' ) ),
		'zerply'      => array( 'title' => esc_attr__( 'Zerply','envision-core' ) ),
		'ebay'        => array( 'title' => esc_attr__( 'Ebay','envision-core' ) ),
		'amazon'      => array( 'title' => esc_attr__( 'Amazon','envision-core' ) ),
		'windows'     => array( 'title' => esc_attr__( 'Windows','envision-core' ) ),
		'apple'       => array( 'title' => esc_attr__( 'Apple','envision-core' ) ),
		'android'     => array( 'title' => esc_attr__( 'Android','envision-core' ) ),
		'whatsapp'    => array( 'title' => esc_attr__( 'Whatsapp','envision-core' ) ),
		'spotify'     => array( 'title' => esc_attr__( 'Spotify','envision-core' ) ),
		'steam'       => array( 'title' => esc_attr__( 'Steam','envision-core' ) ),
		'twitch'      => array( 'title' => esc_attr__( 'Twitch','envision-core' ) ),
		'discord'     => array( 'title' => esc_attr__( 'Discord','envision-core' ) ),
		'vk'          => array( 'title' => esc_attr__( 'VK','envision-core' ) ),
		'okru'        => array( 'title' => esc_attr__( 'Ok.ru','envision-core' ) ),
		'rss'         => array( 'title' => esc_attr__( 'Rss','envision-core' ), 'default' => get_bloginfo( 'rss2_url' ), 'target' => '_self' ),
		'mail'        => array( 'title' => esc_attr__( 'Mail','envision-core' ), 'default' => 'mailto:'. get_bloginfo( 'admin_email' ), 'target' => '_self' ),
		'mailru'      => array( 'title' => esc_attr__( 'Mail.ru','envision-core' ) ),
		'xing'        => array( 'title' => esc_attr__( 'Xing','envision-core' ) ),
	));
}

function cloudfw_socialbar_sprites(){
	return apply_filters( 'cloudfw_socialbar_sprites', array(
		'default'      => esc_html__('Default','envision-core'),
		'colorful'     => esc_html__('Colorful','envision-core'),
		'custom'       => esc_html__('Custom','envision-core'),
	));
}

function cloudfw_socialbar( $option, $services ){
	$option = shortcode_atts(array(
		'echo'              => false,
		'effect'            => 'slide',
		'size'              => null,
		'align'             => null,
		'color'             => '',
		'radius'            => '',
		'icon_color'        => '',
		'start_color'       => '',
		'end_color'         => '',
		'hover_icon_color'  => '',
		'hover_start_color' => '',
		'hover_end_color'   => '',
		'border_color'      => '',
		'borderless'        => true,
		'element'           => 'ul',
		'id'                => '',
		'class'             => '',
		'item_element'      => 'li',
		'item_class'        => '',
		'all_class'         => '',
		'custom_effect'     => '',
		'wrapper'           => false,
		'wrapper_element'   => 'div',
		'wrapper_id'        => '',
		'wrapper_class'     => '',
	), $option);

	$out = '';
	if ( ! empty( $services ) && is_array($services) ) {

		$id = $option['id'];

		if ( empty( $id ) ) {
			$id = cloudfw_id( 'socialbar' );
		}

		/** Get the list of all services */
		$services_list = cloudfw_socialbar_services();

		$with_bg = false;

		$ss_class = array();
		if ( $option['size'] === 'big' ) {
			$ss_class[] = 'ss';
		} else {
			$ss_class[] = 'ssm';
		}

		if ( $option['color'] ) {
			$ss_class[] = 'ui-socialbar-style-'. $option['color'];
		}

		switch ( $option['color'] ) {
			default:
			case 'default':
				$svg_class_normal = '';
				$svg_class_hover = 'ui-socialbar-color-bg';
				break;
			case 'colorful':
				$svg_class_normal = 'ui-socialbar-color-bg ui-socialbar-color-icon';
				$svg_class_hover = 'ui-socialbar-color-bg';
				$with_bg = true;
				break;
			case 'custom':
				$svg_class_normal = '';
				$svg_class_hover = '';
				break;
		}

		/** Define Colors */
		if ( empty( $option['start_color'] ) ) {
			$option['start_color'] = $option['end_color'];
		}

		if ( empty( $option['hover_start_color'] ) ) {
			$option['hover_start_color'] = $option['hover_end_color'];
		}

		/** Check for bg color */
		if ( ! empty( $option['start_color'] ) ) {

		}

		if ( $with_bg ) {
			$ss_class[] = 'with-bg';
		}

		if ( empty( $option['effect'] ) || 'null' === $option['effect'] ) {
			$option['effect'] = 'slide';
		}

		if ( $option['effect'] ) {
			$ss_class[] = 'effect--'. $option['effect'];
		}

		if ( $option['borderless'] ) {
			$ss_class[] = 'borderless';
		}

		if ( $option['radius'] ) {
			if ( !empty( $option['all_class'] ) ) {
				$option['all_class'] .= ' '. $option['radius'];
			} else {
				$option['all_class'] = $option['radius'];
			}
		}

		if ( isset($option['align']) && $option['align'] == 'left' ) {
			$option['align'] = '';
		}

		if ( isset($option['align']) && $option['align'] ) {
			$out .= '<div class="text-' . $option['align'] . '">';
		}


		if ( $option['wrapper'] ) {
			$out .= '<'. $option['wrapper_element'] .' id="'. $option['wrapper_id'] .'" class="'. $option['wrapper_class'] .'">';
		}


		$classes = array();
		$classes[] = 'ui-socialbar';
		$classes[] = 'unstyled';
		$classes[] = $option['class'];
		$classes[] = implode(' ', $ss_class);


		$out .= "<{$option['element']}".
			cloudfw_make_id( $id ) .
			cloudfw_make_class( $classes, true ) .
		">";

		foreach ( $services as $service ) {

			if ( !empty( $service ) && isset($services_list[$service['service']]) ) {
				$service_title = isset($services_list[$service['service']]['title']) ? $services_list[$service['service']]['title'] : null;
				$service_title = isset($services_list[$service['service']]['alt']) ? $services_list[$service['service']]['alt'] : $service_title;
				$service_pattern = isset($services_list[$service['service']]['pattern']) ? $services_list[$service['service']]['pattern'] : null;
				$service_default = isset($services_list[$service['service']]['default']) ? $services_list[$service['service']]['default'] : null;
				$service_target = isset($services_list[$service['service']]['target']) ? $services_list[$service['service']]['target'] : null;
				$service_nofollow= empty($services_list[$service['service']]['nofollow']) || $services_list[$service['service']]['nofollow'] === true ? 'nofollow' : null;
				$service_path = isset($services_list[$service['service']]['path']) ? $services_list[$service['service']]['path'] : null;
				$service_code = isset($services_list[$service['service']]['code']) ? $services_list[$service['service']]['code'] : null;
				$service_color = isset($services_list[$service['service']]['color']) ? $services_list[$service['service']]['color'] : null;
				$service_bg_color = isset($services_list[$service['service']]['bg-color']) ? $services_list[$service['service']]['bg-color'] : null;

				if ( !(isset($service['url']) && $service['url']) && $service_default ) {
					$service['url'] = $service_default;
				}

				$svg = null;

				if ( ! empty( $service_code ) ) {
					$svg = $service_code;
				} else {
					$svg_file = $service_path ? $service_path : path_join( CLOUDFW_SOCIAL_SVG_FOLDER, "{$service['service']}.svg" );
					$svg = file_exists( $svg_file ) ? cloudfw_get_file_contents( $svg_file ) : null;
				}

				$href = apply_filters( 'cloudfw_socialbar_href', ! empty( $service_pattern ) ? sprintf( $service_pattern, $service['url'] ) : $service['url'], $service );

				$item_classes = array();
				$item_classes[] = $service['service'];
				$item_classes[] = $option['item_class'];
				$item_classes[] = $option['all_class'];
				$item_classes[] = 'ui-socialbar-item';
				$item_classes[] = 'ui--animation';

				$item_attributes = array();
				if ( $option['custom_effect'] ) {
					$item_attributes['data-fx'] = $option['custom_effect'];
				}

				$link_classes = array();
				$link_classes[] = 'ui-socialbar-image';
				$link_classes[] = $option['all_class'];

				$out .= "<{$option['item_element']}".
					cloudfw_make_class( $item_classes, true ) .
					cloudfw_make_attribute( $item_attributes, FALSE ) .
				">";

					$out .= "<a".
						cloudfw_make_attribute( array(
							'href' => $href,
							'class' => $link_classes,
							'target' => isset($service_target) ? $service_target : '_blank',
							'title' => isset($service_title) ? $service_title : '',
							'rel' => $service_nofollow,
						), FALSE, TRUE ) .
					">";
					$out .= "<span class=\"ui-socialbar-svg $svg_class_normal\"";
					if ( $with_bg ) {
						$styles = "";
						if ( $service_color ) {
							$styles .= "color: $service_color;";
						}

						if ( $service_bg_color ) {
							$styles .= "background-color: $service_bg_color;";
						}
						if ( ! empty( $styles ) ) {
							$out .= " style=\"$styles\"";
						}
					}
					$out .= ">";
					$out .= $svg;
					$out .= "</span>";

					$out .= "<span class=\"ui-socialbar-svg-hover $svg_class_hover\"";

						$styles = "";
						if ( $service_color ) {
							$styles .= "color: $service_color;";
						}

						if ( $service_bg_color ) {
							$styles .= "background-color: $service_bg_color;";
						}
						if ( ! empty( $styles ) ) {
							$out .= " style=\"$styles\"";
						}
					$out .= ">";
					$out .= $svg;
					$out .= "</span>";
				$out .= "</a>";
				$out .= "</{$option['item_element']}>";

			}

		}

		$out .= '</'. $option['element'] .'>';

		if ( $option['wrapper'] ) {
			$out .= '</'. $option['wrapper_element'] .'>';
		}

		if ( isset($option['align']) && $option['align'] ) {
			$out .= '</div>';
		}

	}

	$css = '';
	$css .= cloudfw_make_style( array(
			"html #{$id} .ui-socialbar-svg",
		), array(
			'gradient' => array( $option['start_color'], $option['end_color'] ),
			'color' => $option['icon_color'],
		), FALSE, FALSE
	);

	$css .= cloudfw_make_style( array(
			"html #{$id} .ui-socialbar-svg-hover",
		), array(
			'gradient' => array( $option['hover_start_color'], $option['hover_end_color'] ),
			'color' => $option['hover_icon_color'],
		), FALSE, FALSE
	);

	$css .= cloudfw_make_style( array(
			"html #{$id} .ui-socialbar-item",
		), array(
			'+border' => $option['border_color'],
		), FALSE, FALSE
	);

	cloudfw_inline_css( $id, $css );
	unset( $css );


	if ( $option['echo'] ) {
		echo cloudfw_escape( $out );
	}

	return $out;
}



cloudfw_register_shortcode( 'CloudFw_Shortcode_Socialbar', null, 'advanced', 66 );
if ( ! class_exists('CloudFw_Shortcode_Socialbar') ) {
	class CloudFw_Shortcode_Socialbar extends CloudFw_Shortcodes {

		function get_called_class(){ return get_class($this); }

		public $do_before = false;

		var $atts   = array();
		var $header = '';
		var $footer = '';
		var $content= '';
		var $services = array();

		function __construct() {
			$this->services = cloudfw_socialbar_services();
		}

		/**
		 *  Add
		 */
		function add() {
			return array(
				'socialbar'             => array( &$this, 'socialbar' ),
				'socialbar_service'     => array( &$this, 'socialbar_service' ),
			);
		}

		/*
		 *  Shortcode via Composer
		 */
		function shortcode($atts, $content = null, $case = null){
			$services = cloudfw_walk_options( array(
				'indicator' => 'indicator',
				'service'   => 'socialbar_service_id',
				'url'       => 'socialbar_service_url',
			), $atts );

			return cloudfw_socialbar( $atts, $services );

		}

		/*
		 *  Shortcode via Manual Code
		 */
		function socialbar($atts, $content = null, $case = null){

			$this->contents = array();
			do_shortcode( $content );

			return cloudfw_socialbar( $atts, $this->contents );
		}

		/**
		 *  Items
		 */
		function socialbar_service($atts, $content = null, $case = null){
			$atts = shortcode_atts(array(
				'service'   => '',
				'url'       => '',
			), $atts);

			$this->contents[] = $atts;
		}

		/** Add the shortcode to the composer */
		function composer(){
			return array(
				'composer'      => true,
				'droppable'     => false,
				'ajax'          => true,
				'icon'          => 'social-services',
				'group'         => 'composer_widgets',
				'line'          => 390,
				'options'       => array(
					'title'             => __('Social Services','envision-core'),
					'column'            => '1/1',
				)
			);
		}

		/** Admin Scheme */
		function scheme() {

			return array(
				'title'     =>  __('Social Services','envision-core'),
				'script'    => array(
					'shortcode'     => 'socialbar',
					'tag_close'     => true,
					'tag_newline'   => false,
					'attributes'    => array(
						'size'              => array( 'e' => 'socialbar_size' ),
						'align'             => array( 'e' => 'socialbar_align' ),
						'color'             => array( 'e' => 'socialbar_color' ),
						'radius'            => array( 'e' => 'socialbar_radius' ),
						'effect'            => array( 'e' => 'socialbar_effect' ),

						'icon_color'        => array( 'e' => 'socialbar_icon_color' ),
						'start_color'       => array( 'e' => 'socialbar_background_0' ),
						'end_color'         => array( 'e' => 'socialbar_background_1' ),
						'hover_icon_color'  => array( 'e' => 'socialbar_hover_icon_color' ),
						'hover_start_color' => array( 'e' => 'socialbar_hover_background_0' ),
						'hover_end_color'   => array( 'e' => 'socialbar_hover_background_1' ),

						'border_color'      => array( 'e' => 'socialbar_border_color' ),
						'custom_effect'     => array( 'e' => 'socialbar_custom_effect' ),

						'content'           => array(
							'e'             => 'socialbar_services_all',
							'multi'             => 'socialbar_service_clone_class',
							'check_visiblity' => false,
							'tag_newline'   => false,
							'data'              => array(

								array(
									'id'     => 'socialbar_service',
									'script' => array(
										'shortcode'     => 'socialbar_service',
										'tag_close'     => false,
										'tag_newline_default' => true,
										'prepend'       => '\'+$tb+\'',
										'attributes'    => array(
											'service'       => array( 'e' => 'socialbar_service_id' ),
											'url'           => array( 'e' => 'socialbar_service_url' ),
										)
									),
								)

							)

						),
					),

				),
				'data'      =>  $this->global_scheme()

			);

		}

		/**
		 *  Global Render Scheme
		 */
		function global_scheme(){
			foreach ( (array) $this->services as $service_id => $service )
				$this->services_select[ $service_id ] = $service['title'];

			return array(

					array(
						'type'      =>  'module',
						'condition' =>  $this->is_widget,
						'title'     =>  __('Title','envision-core'),
						'data'      =>  array(
							array(
								'type'      =>  'text',
								'id'        =>  $this->get_field_name('title'),
								'value'     =>  $this->get_value('title'),
								'_class'        =>  'widefat',
							)
						),
					),


					array(
						'type'      =>  'mini-section',
						'title'     =>  __('Icon Set','envision-core'),
						'data'      =>  array(

							array(
								'type'      =>  'module',
								'title'     =>  __('Icon Set','envision-core'),
								'data'      =>  array(
									array(
										'type'      =>  'select',
										'id'        =>  $this->get_field_name('socialbar_color'),
										'value'     =>  $this->get_value('socialbar_color'),
										'source'    =>  array(
											'type'      =>  'function',
											'function'  =>  'cloudfw_socialbar_sprites',
										),
										'width'     =>  '400',
									)
								)
							),

							array(
								'type'      =>  'module',
								'title'     =>  __('Icon Size','envision-core'),
								'data'      =>  array(
									array(
										'type'      =>  'select',
										'id'        =>  $this->get_field_name('socialbar_size'),
										'value'     =>  $this->get_value('socialbar_size'),
										'source'    =>  array(
											'null'      =>  __('30px','envision-core'),
											'big'       =>  __('40px','envision-core'),
										),
										'width'     =>  '250',
									)
								),
							),
						)
					),

					array(
						'type'      =>  'mini-section',
						'title'     =>  __('Options','envision-core'),
						'data'      =>  array(

							array(
								'type'      =>  'module',
								'title'     =>  __('Hover Effect','envision-core'),
								'data'      =>  array(
									array(
										'type'      =>  'select',
										'id'        =>  $this->get_field_name('socialbar_effect'),
										'value'     =>  $this->get_value('socialbar_effect'),
										'source'    =>  array(
											'null'      =>  __('Slide','envision-core'),
											'fade'      =>  __('Fade','envision-core'),
										),
										'width'     =>  '250',
									)
								),
							),

							array(
								'type'      =>  'module',
								'title'     =>  __('Align','envision-core'),
								'data'      =>  array(
									array(
										'type'      =>  'select',
										'id'        =>  $this->get_field_name('socialbar_align'),
										'value'     =>  $this->get_value('socialbar_align'),
										'source'    =>  array(
											'null'      =>  __('Left','envision-core'),
											'center'    =>  __('Center','envision-core'),
											'right'     =>  __('Right','envision-core'),
										),
										'width'     =>  '250',
									)
								),
							),

							array(
								'type'      =>  'module',
								'title'     =>  __('Border Radius','envision-core'),
								'data'      =>  array(
									array(
										'type'      =>  'select',
										'id'        =>  $this->get_field_name('socialbar_radius'),
										'value'     =>  $this->get_value('socialbar_radius'),
										'source'    =>  array(
											'null'          => __('Default','envision-core'),
											'radius-circle' => __('Circle','envision-core'),
											'radius-3px'    => __('3px Radius','envision-core'),
											'radius-30px'   => __('30px Radius','envision-core'),
											'no-radius'     => __('No Radius','envision-core'),
										),
										'width'     =>  '250',
									)
								),
							),

							array(
								'type'      => 'module',
								'title'     => __('Custom Transition Effect','envision-core'),
								'data'      => array(

									## Element
									array(
										'type'      =>  'select',
										'id'        =>  $this->get_field_name('socialbar_custom_effect'),
										'value'     =>  $this->get_value('socialbar_custom_effect'),
										'source'    =>  array(
											'type'      =>  'function',
											'function'  =>  'cloudfw_css_effect_list',
										),
										'width'     =>  400,
									),

								)

							),

						)
					),

					array(
						'type'      =>  'mini-section',
						'title'     =>  __('Colors','envision-core'),
						'data'      =>  array(

							## Module Item
							array(
								'type'      =>  'module',
								'title'     =>  __('Icon Color','envision-core'),
								'data'      =>  array(
									array(
										'type'      =>  'color',
										'id'        =>  $this->get_field_name('socialbar_icon_color'),
										'value'     =>  $this->get_value('socialbar_icon_color'),
									)
								),
							),

							array(
								'type'      =>  'module',
								'title'     =>  __('Background','envision-core'),
								'data'      =>  array(
									array(
										'type'      =>  'gradient',
										'id'        =>  $this->get_field_name('socialbar_background'),
										'value'     =>  array( $this->get_value('socialbar_background_0'), $this->get_value('socialbar_background_1') ),
									)
								),
							),

							## Module Item
							array(
								'type'      =>  'module',
								'title'     =>  __('Hover Icon Color','envision-core'),
								'data'      =>  array(
									array(
										'type'      =>  'color',
										'id'        =>  $this->get_field_name('socialbar_hover_icon_color'),
										'value'     =>  $this->get_value('socialbar_hover_icon_color'),
									)
								),
							),

							## Module Item
							array(
								'type'      =>  'module',
								'title'     =>  __('Hover Background','envision-core'),
								'data'      =>  array(
									array(
										'type'      =>  'gradient',
										'id'        =>  $this->get_field_name('socialbar_hover_background'),
										'value'     =>  array( $this->get_value('socialbar_hover_background_0'), $this->get_value('socialbar_hover_background_1') ),
									)
								),
							),

							## Module Item
							array(
								'type'      =>  'module',
								'title'     =>  __('Border Color','envision-core'),
								'data'      =>  array(
									array(
										'type'      =>  'color',
										'style'     =>  'horizontal',
										'id'        =>  $this->get_field_name('socialbar_border_color'),
										'value'     =>  $this->get_value('socialbar_border_color'),
									)
								),
							),

						)

					),

					array(
						'type'      =>  'mini-section',
						'title'     =>  __('Services','envision-core'),
					),

					array(
						'type'      =>  'sorting',
						'id'        =>  'socialbar_sorting',
						'item:id'   =>  'socialbar_service_clone',
						'data'      =>

							cloudfw_core_loop_multi_option(

								array(
									'start'     => 5,
									'indicator' => $this->get_value('indicator'),
									'dummy'     => true,
									'data'      =>

										array(
											'type'      =>  'module',
											'title'     =>  _if( !$this->is_widget , __('Service','envision-core') ),
											'layout'    =>  'vertical',
											'_class'    => 'socialbar_service_clone_class',
											'data'      =>  array(

												## Module Item
												array(
													'type'      =>  'remove',
												),

												## Module Item
												array(
													'type'      =>  'indicator',
													'id'        =>  $this->get_field_name('indicator'),
												),

												## Element
												array(
													'type'      =>  'select',
													'title'     =>  __('Service','envision-core'),
													'id'        =>  $this->get_field_name('socialbar_service_id'),
													'value'     =>  $this->get_value('socialbar_service_id'),
													'reset'     =>  '',
													'source'    =>  $this->services_select,
													'width'     =>  '200',
													'brackets'  =>  true

												), // #### element: 0

												## Element
												array(
													'type'      =>  'text',
													'title'     =>  __('URL','envision-core'),
													'id'        =>  $this->get_field_name('socialbar_service_url'),
													'value'     =>  $this->get_value('socialbar_service_url'),
													'reset'     =>  '',
													'_class'    => 'input_150 tab_item_title',
													'brackets'  =>  true

												), // #### element: 0

											)

										),

								)

							)

					),

					## Element
					array(
						'type'      =>  'html',
						'data'      =>  '<a data-target="" class="cloudfw-action-duplicate cloudfw-ui-button cloudfw-ui-button-metro cloudfw-ui-button-metro-green" href="javascript:;"><span>'.__('+ Add New Service','envision-core').'</span></a>',
					), // #### element: 0
			);


		}

	}

}

/** Class */
class CloudFw_Widget_Socialbar extends CloudFw_Widgets{
	/** Variables */
	public $services = array();
	public $services_dir = '';
	private $class;

	/** Init */
	function __construct() {
		parent::__construct(
			/** Base ID */
			'widget_cloudfw_socialbar',
			/** Title */
			__('Theme - Socialbar','envision-core'),
			/** Other Options */
			array(
				'classname' => 'widget_cloudfw_socialbar',
				'description' => '',
			),
			/** Size */
			array( 'width' => 300 )
		);

		/** Services */
		$this->class = new CloudFw_Shortcode_Socialbar();
		$this->class->is_widget = true;
		$this->class->widget = $this;
	}

	/** Render */
	function widget($args, $instance) {
		extract($args, EXTR_SKIP);
		$title = isset($instance['title']) ? $instance['title'] : null;

		echo cloudfw_escape( $before_widget);
		$title = empty($title) ? '' : apply_filters('widget_title', $title);

		if ( !empty( $title ) )
			echo cloudfw_escape( $before_title . $title . $after_title );

		$shortcode_options = $this->class->scheme();
		$instance = cloudfw_composer_convert_data( $instance, $shortcode_options['script'] );

			echo do_shortcode($this->class->shortcode( $instance ));

		echo cloudfw_escape( $after_widget);
	}

	/** Scheme */
	function scheme( $data = array() ) {

		/** Defaults */
		$data = wp_parse_args( $data, array() );
		$this->class->set_data( $data );

		$services = array();
		foreach ( (array) $this->class->services as $service_id => $service )
			$services[ $service_id ] = $service['title'];

		$scheme = array();
		$scheme['data'] = $this->class->global_scheme();

		return $scheme;

	}

}


/**
 *  Register Widget
 */
register_widget('CloudFw_Widget_Socialbar');