<?php
/**
Plugin Name: WP Plugin Manager Pro
Plugin URI: https://hasthemes.com/plugins/
Description: WP Plugin Manager is a WordPress plugin that allows you to disable/enable plugins for certain pages, posts or URI conditions.
Version: 1.0.4
Author: codecarnival
Author URI: https://hasthemes.com/
Text Domain: htpmpro
*/

defined( 'ABSPATH' ) or die();

/**
 * Define path
 */
define( 'HTPMPRO_ROOT_PL', __FILE__ );
define( 'HTPMPRO_ROOT_URL', plugins_url('', HTPMPRO_ROOT_PL) );
define( 'HTPMPRO_PL_ROOT', HTPMPRO_ROOT_PL );
define( 'HTPMPRO_ROOT_DIR', dirname( HTPMPRO_ROOT_PL ) );
define( 'HTPMPRO_PLUGIN_DIR', plugin_dir_path( __DIR__ ) );
define( 'HTPMPRO_PLUGIN_BASE', plugin_basename( HTPMPRO_ROOT_PL ) );

/**
 * Include files
 */
require_once HTPMPRO_ROOT_DIR . '/includes/helper_functions.php';
require_once HTPMPRO_ROOT_DIR . '/includes/plugin-options-page.php';
require_once HTPMPRO_ROOT_DIR . '/includes/licence/WPPluginManagerPro.php';

/**
 * Load text domain
 */
function htpmpro_load_textdomain() {
    load_plugin_textdomain( 'htpmpro', false, dirname( plugin_basename( __FILE__ ) ) . '/languages/' );
}
add_action( 'init', 'htpmpro_load_textdomain' );


/**
 * Plugin activation hook
 */
register_activation_hook( __FILE__, 'htpmpro_plugin_activation' );
function htpmpro_plugin_activation(){
	if(empty(get_option('htpmpro_status')) || get_option('htpmpro_status')){
		update_option('htpmpro_status', 'active');
    }
    else {
      	add_option('htpmpro_status', 'active');
    }

    // replace the old file
    $mu_plugin_file_source_path = HTPMPRO_ROOT_DIR . '/mu-plugin/htpm-mu-plugin.php';

    $mu_plugin_file = 'htpm-mu-plugin.php';
    if ( defined( 'WPMU_PLUGIN_DIR' ) ) {
        $mu_plugins_path = WPMU_PLUGIN_DIR;
    } else {
        $mu_plugins_path = WP_CONTENT_DIR . '/' . 'mu-plugins';
    }

    $mu_plugin_file_path = $mu_plugins_path . '/htpm-mu-plugin.php';

    // add mu file 
    if ( file_exists( $mu_plugins_path ) ){
        copy( $mu_plugin_file_source_path, $mu_plugin_file_path );
    }
}

/**
 * Plugin deactivation hook
 */
register_deactivation_hook( __FILE__, 'htpmpro_plugin_deactivation' );
function htpmpro_plugin_deactivation(){
	if(empty(get_option('htpmpro_status')) || get_option('htpmpro_status')){
		update_option('htpmpro_status', 'deactive');
    }
    else {
      	add_option('htpmpro_status', 'deactive');
    }
}

/**
 * Plugin deactivation lite version
 */
if( is_plugin_active('wp-plugin-manager/plugin-main.php') ){
    add_action('update_option_active_plugins', 'htpmpro_deactivate_lite_version');
}
function htpmpro_deactivate_lite_version(){
   deactivate_plugins('wp-plugin-manager/plugin-main.php');
}

/**
 * Enqueue admin scripts and styles.
 */
function htpmpro_admin_scripts( $hook_suffix ) {
	if( $hook_suffix ==  'plugin-manager_page_htpmpro-options' ){
		wp_enqueue_style( 'select2', HTPMPRO_ROOT_URL . '/assets/css/select2.min.css' );
		wp_enqueue_style( 'htpmpro-admin', HTPMPRO_ROOT_URL . '/assets/css/admin-style.css' );
		wp_enqueue_style( 'jquery-ui', HTPMPRO_ROOT_URL . '/assets/css/jquery-ui.css' );
        wp_enqueue_style( 'htmpro-admin-options', HTPMPRO_ROOT_URL . '/assets/css/admin-options.css' );

		// load jquery ui files
		wp_enqueue_script( 'jquery-ui-accordion');
		wp_enqueue_script( 'select2', HTPMPRO_ROOT_URL . '/assets/js/select2.min.js', array('jquery'), '', true );
		wp_enqueue_script( 'htpmpro-admin', HTPMPRO_ROOT_URL . '/assets/js/admin.js', array('jquery'), '', true );
        wp_enqueue_script( 'htpmpro-install-manager', HTPMPRO_ROOT_URL . '/assets/js/install_manager.js', array('jquery', 'wp-util', 'updates'), '', true );

        if( is_admin() ){
            $localize_data = [
                'ajaxurl'          => admin_url( 'admin-ajax.php' ),
                'adminURL'         => admin_url(),
                'pluginURL'        => plugin_dir_url( __FILE__ ),
                'message'          =>[
                    'packagedesc'=> esc_html__( 'in this package', 'htpmpro' ),
                    'allload'    => esc_html__( 'All Items have been Loaded', 'htpmpro' ),
                    'notfound'   => esc_html__( 'Nothing Found', 'htpmpro' ),
                ],
                'buttontxt'      =>[
                    'tmplibrary' => esc_html__( 'Import to Library', 'htpmpro' ),
                    'tmppage'    => esc_html__( 'Import to Page', 'htpmpro' ),
                    'import'     => esc_html__( 'Import', 'htpmpro' ),
                    'buynow'     => esc_html__( 'Buy Now', 'htpmpro' ),
                    'preview'    => esc_html__( 'Preview', 'htpmpro' ),
                    'installing' => esc_html__( 'Installing..', 'htpmpro' ),
                    'activating' => esc_html__( 'Activating..', 'htpmpro' ),
                    'active'     => esc_html__( 'Active', 'htpmpro' ),
                ],
            ];
            wp_localize_script( 'htpmpro-admin', 'HTMPRO', $localize_data );

        }
	}
}
add_action( 'admin_enqueue_scripts', 'htpmpro_admin_scripts' );


/**
 * Plugins Setting Page
 */
add_filter('plugin_action_links_'.HTPMPRO_PLUGIN_BASE, 'htpmpro_plugins_setting_links' );
function htpmpro_plugins_setting_links( $links ) {
    $settings_link = '<a href="'.admin_url('admin.php?page=htpmpro-options').'">'.esc_html__( 'Settings', 'htpmpro' ).'</a>'; 
    array_unshift( $links, $settings_link );
    return $links; 
}

/**
 * Ajax plugins activation request
 */
add_action( 'wp_ajax_htmpro_ajax_plugin_activation', 'htpmpro_ajax_plugin_activation');

function htpmpro_ajax_plugin_activation() {

    if ( ! current_user_can( 'install_plugins' ) || ! isset( $_POST['location'] ) || ! $_POST['location'] ) {
        wp_send_json_error(
            array(
                'success' => false,
                'message' => esc_html__( 'Plugin Not Found', 'htpmpro' ),
            )
        );
    }

    $plugin_location = ( isset( $_POST['location'] ) ) ? esc_attr( $_POST['location'] ) : '';
    $activate    = activate_plugin( $plugin_location, '', false, true );

    if ( is_wp_error( $activate ) ) {
        wp_send_json_error(
            array(
                'success' => false,
                'message' => $activate->get_error_message(),
            )
        );
    }

    wp_send_json_success(
        array(
            'success' => true,
            'message' => esc_html__( 'Plugin Successfully Activated', 'htpmpro' ),
        )
    );

}

/**
 * Add mu file
 */
function htpmpro_create_mu_file(){
    
    $mu_plugin_file_source_path = HTPMPRO_ROOT_DIR . '/mu-plugin/htpm-mu-plugin.php';
    $mu_plugins = get_mu_plugins();

    $mu_plugin_file = 'htpm-mu-plugin.php';
    if ( defined( 'WPMU_PLUGIN_DIR' ) ) {
        $mu_plugins_path = WPMU_PLUGIN_DIR;
    } else {
        $mu_plugins_path = WP_CONTENT_DIR . '/' . 'mu-plugins';
    }

    $mu_plugin_file_path = $mu_plugins_path . '/htpm-mu-plugin.php';

    // add mu file 
    if ( file_exists( $mu_plugins_path ) && !array_key_exists( $mu_plugin_file, $mu_plugins ) ){
        copy( $mu_plugin_file_source_path, $mu_plugin_file_path );
    } else {
        // create mu-plugins folder
        if ( !file_exists($mu_plugins_path) ) {
            $create_mu_folder = mkdir( $mu_plugins_path, 0755, true );
            if( $create_mu_folder ){
                copy( $mu_plugin_file_source_path, $mu_plugin_file_path );
            }
        }
    }
}
add_action('init', 'htpmpro_create_mu_file');