<?php

if ( ! class_exists('CloudFw_Walker_Top_Menu') ) {
    /**
     *  CloudFw Custom Navigation Menu Walker
     *
     *  @since 1.0
    **/
    class CloudFw_Walker_Top_Menu extends Walker_Nav_Menu {

        function display_element ($element, &$children_elements, $max_depth, $depth = 0, $args, &$output) {

            $hide_item = false;
            $condition_result_login = cloudfw_get_post_meta($element->ID, 'menu_logical_condition_result', 'show');
            $condition_login = cloudfw_get_post_meta($element->ID, 'menu_logical_condition');

            if( ! empty( $condition_result_login ) ) {
                switch ($condition_login) {
                    case 'is_logged_in':

                        if ( $condition_result_login == 'hide' && is_user_logged_in() ) {
                            $hide_item = true;
                        } elseif ( $condition_result_login == 'show' && !is_user_logged_in() ) {
                            $hide_item = true;
                        }

                        break;

                    case 'is_not_logged_in':

                        if ( $condition_result_login == 'hide' && !is_user_logged_in() ) {
                            $hide_item = true;
                        } elseif ( $condition_result_login == 'show' && is_user_logged_in() ) {
                            $hide_item = true;
                        }

                        break;
                }
            }

            $condition_result_roles = cloudfw_get_post_meta($element->ID, 'menu_logical_condition_roles_result', 'show');
            $condition_roles = cloudfw_get_post_meta($element->ID, 'menu_logical_condition_roles');

            if( $hide_item !== true && ! empty( $condition_result_roles ) && ! empty( $condition_roles ) ) {
                if ( $condition_result_roles == 'hide' && current_user_can( $condition_roles ) ) {
                    $hide_item = true;
                } elseif ( $condition_result_roles == 'show' && !current_user_can( $condition_roles ) ) {
                    $hide_item = true;
                }
            }

            if ( isset($hide_item) && $hide_item === true ) {
                $this->unset_children( $element, $children_elements );
                return false;
            }

            $element->has_children = isset($children_elements[$element->ID]) && !empty($children_elements[$element->ID]);

            return parent::display_element($element, $children_elements, $max_depth, $depth, $args, $output);
        }


        function start_el(&$output, $item, $depth = 0, $args = array(), $id = 0) {
           $indent = ( $depth ) ? str_repeat( "\t", $depth ) : '';
           $class_names = $value = '';

           $classes = empty( $item->classes ) ? array() : (array) $item->classes;
           $link_classes = array();

           $classes[] = 'depth-'.$depth;

            $dropdown_position = cloudfw_get_post_meta($item->ID, 'dropdown_direction', 'right');

            if ( is_rtl() ){
                if ( $dropdown_position == 'right' ) {
                    $dropdown_position = 'left';
                } else {
                    $dropdown_position = 'right';
                }
            }

            if ( $dropdown_position ) {
                $classes[] = 'to-' . $dropdown_position;
            }

            if ( $depth > 0 ) {
                $text_align = cloudfw_get_post_meta($item->ID, 'dropdown_text_align', '');
                if ( $text_align )
                    $link_classes[] = 'text-' . $text_align;

            }

           if ( $depth === 0 && !empty( $this->top_level_class )  ) {
                $classes[] = $this->top_level_class;
           }

            $class_names = join( ' ', apply_filters( 'nav_menu_css_class', array_filter( $classes ), $item ) );
            $class_names = ' class="'. esc_attr( $class_names ) . '"';
            $link_class_names = join( ' ', array_filter( $link_classes ) );

            $output .= $indent . '<li ';
            $output .= $item->ID ? 'id="menu-item-' . $item->ID .'"' : '';
            $output .= $value . $class_names .'>';
            $attributes  = ! empty( $item->attr_title ) ? ' title="'  . esc_attr( $item->attr_title ) .'"' : '';
            $attributes .= ! empty( $item->target )     ? ' target="' . esc_attr( $item->target     ) .'"' : '';
            $attributes .= ! empty( $item->xfn )        ? ' rel="'    . esc_attr( $item->xfn        ) .'"' : '';
            $attributes .= ! empty( $item->url )        ? ' href="'   . esc_attr( $item->url        ) .'"' : '';
            $attributes .= ! empty( $link_class_names ) ? ' class="'. esc_attr( $link_class_names ) . '"' : '';

            $item_output = $args->before;

            $item_output .= $args->link_before;
            $item_output .= '<a'. $attributes .'>';
            $item_output .= apply_filters( 'the_title', $item->title, $item->ID );

            //if ( $depth === 0 )
                if ( isset($item->has_children) && $item->has_children && !empty( $args->caret ) )
                    if ( $depth === 0 )
                        $item_output .= $args->caret;
                    else {
                        if ( $dropdown_position == 'left' )
                            $item_output .= isset($args->sub_level_caret_left) ? $args->sub_level_caret_left : NULL;
                        else
                            $item_output .= isset($args->sub_level_caret_right) ? $args->sub_level_caret_right : NULL;
                    }

            $item_output .= '</a>';
            $item_output .= $args->link_after;

            $item_output .= $args->after;

            $output .= apply_filters( 'walker_nav_menu_start_el', $item_output, $item, $depth, $args );
        }

    }

}