<?php
 function cloudfw_run_typo_modules() {
 	cloudfw_render_page(
 		cloudfw_get_schemes('font_map', true, cloudfw_get_font_data()),
 		isset($GLOBALS["args"]) ? $GLOBALS["args"] : NULL
 	);
}

function cloudfw_font_sizes() {
	$out = array();
	//$out['NULL'] = __('Default','cloudfw');
	$out['NULL'] = '-';

	for ( $i=9; $i <= 96 ; $i++ ) {
		$out[ ''.$i.'' ] = $i . 'px';
	}

	return $out;
}

function cloudfw_font_line_heights() {
	$out = array();
	$out['NULL'] = '-';

	for ( $i=9; $i <= 120 ; $i++ ) {
		$out[ ''.$i.'' ] = $i . 'px';
	}

	return $out;
}

function cloudfw_font_weights() {
	$out = array();
	//$out['NULL'] = __('Default','cloudfw');
	$out['NULL'] = '-';

	$out['100'] = '100';
	$out['200'] = '200';
	$out['300'] = '300';
	$out['400'] = __('Normal','envision');
	$out['500'] = '500';
	$out['600'] = __('Bold','envision');
	$out['700'] = '700';
	$out['900'] = '900';

	return $out;
}

function cloudfw_font_letter_spacing() {
	$out = array();
	//$out['NULL'] = __('Default','cloudfw');
	$out['NULL'] = '-';

	$out['-2px']   = '-2px';
	$out['-1.5px'] = '-1.5px';
	$out['-1px']   = '-1px';
	$out['-0.5px'] = '-0.5px';
	$out['0px']    = '0px';
	$out['0.5px']  = '0.5px';
	$out['1px']    = '1px';
	$out['1.5px']  = '1.5px';
	$out['2px']    = '2px';

	return $out;
}

function cloudfw_grouped_font_list_cached() {
 	static $font_list;

	if (!empty($font_list))
		return $font_list;

	$font_list = cloudfw_grouped_font_list();
	return $font_list;
}


/**
 *	Grouped Font Array
 *
 *	@since 1.0
 */
function cloudfw_grouped_font_list(){
	global $_opt, $cloudfw_default_fonts;

	$fonts = cloudfw_get_fonts();
	$custom_fonts = cloudfw_fontface_get_fonts();
	$google_fonts = cloudfw_webfonts_get_fonts();
	$service_fonts = cloudfw_servicefonts_get_fonts();

	$array_fonts['NULL'] = esc_html__("Default",'envision');

	if (is_array($fonts)){
		foreach ($fonts as $font_id) {
			 if (cloudfw_get_font_type($font_id) == "custom") {
				$custom_array_fonts[ $custom_fonts[$font_id]["name"] ] = $custom_fonts[$font_id]["name"];
			} elseif (cloudfw_get_font_type($font_id) == "google") {
				$google_array_fonts[ $google_fonts[$font_id]["family"] ] = $google_fonts[$font_id]["name"];
			} elseif (cloudfw_get_font_type($font_id) == "service") {
				$service_array_fonts[ $service_fonts[$font_id]["family"] ] = $service_fonts[$font_id]["name"];
			}
		}
	} else {
		return false;
	}

	foreach((array)$cloudfw_default_fonts as $font_id => $font_det) {
		$default_array_fonts[ $font_id ] = $font_det["name"];
	}

	if (isset($default_array_fonts) && $default_array_fonts) {
		$array_fonts[ __("System Fonts",'envision') ] = $default_array_fonts;
	}

	if (isset($custom_array_fonts) && $custom_array_fonts) {
		$array_fonts[ __("Installed Fonts",'envision') ] = $custom_array_fonts;
	}

	if (isset($google_array_fonts) && $google_array_fonts) {
		$array_fonts[ __("Installed Google Web Fonts",'envision') ] = $google_array_fonts;
	}

	if (isset($service_array_fonts) && $service_array_fonts) {
		$array_fonts[ __("Service Fonts",'envision') ] = $service_array_fonts;
	}

	return $array_fonts;
}


function cloudfw_admin_get_custom_fonts_array() {
	$fonts = cloudfw_fontface_get_fonts();

	if ( is_array($fonts) ) {
		@asort($fonts);
	}

	$custom_fonts_array = array();

	$i = 0;
	foreach ((array)$fonts as $font_id => $font) {

		$custom_fonts_array[] =  array(
			"item_value"	=> $font_id,
			"item_class"	=> "",
			"item_html" 	=> '<span id="fontface-custom-preview-'. $i .'" class="skin-name no-bold fontface-preview">'.$font["name"].'</span>',
			"item_before" 	=> '<span class="edit_remove_skin_container">',
			"item_after"	=> '
				<span class="edit_remove_skin">
					<a class="duplicate copyFontNameZclip cloudfw-tooltip" title="'.__('Copy Font Name','envision').'" href="javascript:void(0);">
						<input class="cloudfw-copy-content" value="'. esc_attr( $font["name"] ) .'" />
					</a>
				</span>
			</span>'
		);

		$i++;

	}

	return $custom_fonts_array;

}

function cloudfw_admin_get_google_fonts_array() {
	$fonts = cloudfw_webfonts_get_fonts();

	if ( is_array($fonts) )
		@asort($fonts);

	$i = 0;
	foreach ((array)$fonts as $font_id => $font) {
		if ( empty($font["family"]) )
			continue;

		$name = '';
		if( $font["name"] )
			$name = $font["name"];
		else
			$name = cloudfw_webfonts_parse_fontfamily( $font["family"] );

		$google_fonts_array[] =  array(
			"item_value"	=> $font_id,
			"item_class"	=> "",
			"item_html" 	=> '<span id="fontface-webfont-preview-'. $i .'" class="skin-name no-bold fontface-preview">'.$name.'</span>',
			"item_before" 	=> '<span class="edit_remove_skin_container">',
			"item_after"	=> '
				<span class="edit_remove_skin">
					<a class="duplicate copyFontNameZclip cloudfw-tooltip" title="'.__('Copy Font Name','envision').'" href="javascript:void(0);">
						<input class="cloudfw-copy-content" value="'. esc_attr( $font["family"] ) .'" />
					</a>
				</span>
			</span>'
		);
		$i++;

	}

	return $google_fonts_array;

}

/**
 *	CloudFw Webfonts - Get all fonts via Google API
 *
 *	@since 1.0
 */
function cloudfw_admin_get_google_font_list() {
	$font_array = array();

   $font_array = get_transient(PFIX . '_google_webfonts');
    if ( $font_array !== false )
        return $font_array;


	$font_array['NULL'] = '';
	$need_defaults = true;

	if ( $need_defaults ) {
		if ( file_exists(TMP_LOADERS . '/theme.webfonts.php') ) {
			include( TMP_LOADERS . '/theme.webfonts.php' );
		}
	}

	return $font_array;

}
