<?php

function cloudfw_woocommerce_before_shop_loop() {
	global $wp_query;

	$content = null;

	if ( $wp_query ) {
		if ( $wp_query->is_tax() || $wp_query->is_category() ) {
			$content = cloudfw_get_option( 'woocommerce',  'code_shop_archive_before_products' );
		} else {
			$content = cloudfw_get_option( 'woocommerce',  'code_shop_before_products' );
		}
	}

	if ( ! empty ( $content ) ) {
		echo do_shortcode( $content );
	}
}

function cloudfw_woocommerce_after_shop_loop() {
	global $wp_query;
	$content = null;

	if ( $wp_query ) {
		if ( $wp_query->is_tax() || $wp_query->is_category() ) {
			$content = cloudfw_get_option( 'woocommerce',  'code_shop_archive_after_products' );
		} else {
			$content = cloudfw_get_option( 'woocommerce',  'code_shop_after_products' );
		}
	}

	if ( ! empty ( $content ) ) {
		echo do_shortcode( $content );
	}
}

add_action( 'woocommerce_before_shop_loop', 'cloudfw_woocommerce_before_shop_loop', 9 );
add_action( 'woocommerce_after_shop_loop', 'cloudfw_woocommerce_after_shop_loop', 9 );


add_action( 'woocommerce_after_cart_item_name', 'cloudfw_woocommerce_after_cart_item_name', 10, 2 );
function cloudfw_woocommerce_after_cart_item_name( $cart_item, $cart_item_key ){
	$_product   = apply_filters( 'woocommerce_cart_item_product', $cart_item['data'], $cart_item, $cart_item_key );
	$product_id = apply_filters( 'woocommerce_cart_item_product_id', $cart_item['product_id'], $cart_item, $cart_item_key );

	echo apply_filters( // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped
		'woocommerce_cart_item_remove_link',
		sprintf(
			'<a href="%s" class="remove remove-link" aria-label="%s" data-product_id="%s" data-product_sku="%s">Remove item</a>',
			esc_url( wc_get_cart_remove_url( $cart_item_key ) ),
			esc_html__( 'Remove this item', 'envision' ),
			esc_attr( $product_id ),
			esc_attr( $_product->get_sku() )
		),
		$cart_item_key
	);
}

/** Translatable Strings */
//add_filter( 'woocommerce_variation_free_price_html', 'cloudfw_woocommerce_sale_price_html', 10, 2 );
//add_filter( 'woocommerce_variable_free_price_html', 'cloudfw_woocommerce_sale_price_html', 10, 2 );

/**
 * Gets Price HTML "From" Text
 * @param  string $price
 * @return string
 */
/*function cloudfw_woocommerce_get_price_html_from_text( $price ){
	return sprintf( cloudfw_translate( 'wc.price_from' ), $price);
}

add_filter( 'woocommerce_variable_sale_price_html', 'cloudfw_woocommerce_variable_sale_price_html', 10, 2 );
function cloudfw_woocommerce_variable_sale_price_html( $price, $that ){
	$price = $that->get_price_html_from_to( $that->min_variation_regular_price, $that->get_price() );

	if ( ! $that->min_variation_price || $that->min_variation_price !== $that->max_variation_price ) {
		$price = cloudfw_woocommerce_get_price_html_from_text( $price );
	}

	return $price;
}


add_filter( 'woocommerce_variable_free_sale_price_html', 'cloudfw_woocommerce_variable_free_sale_price_html', 10, 2 );
function cloudfw_woocommerce_variable_free_sale_price_html( $price, $that ){
	$price = $that->get_price_html_from_to( $that->min_variation_regular_price, cloudfw_translate( 'wc.price_free' ) );

	if ( $that->min_variation_price !== $that->max_variation_price ) {
		$price = cloudfw_woocommerce_get_price_html_from_text( $price );
	}

	return $price;
}


add_filter( 'woocommerce_free_price_html', 'cloudfw_woocommerce_sale_price_html', 10, 2 );
add_filter( 'woocommerce_variation_free_price_html', 'cloudfw_woocommerce_sale_price_html', 10, 2 );
function cloudfw_woocommerce_sale_price_html( $price, $that ){
	return cloudfw_translate( 'wc.price_free' );
}

add_filter( 'woocommerce_free_sale_price_html', 'cloudfw_woocommerce_free_sale_price_html', 10, 2 );
function cloudfw_woocommerce_free_sale_price_html( $price, $that ){
	return $that->get_price_html_from_to( $that->regular_price, cloudfw_translate( 'wc.price_free' ) );
}*/
